/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class TypedefStatementSupport
extends AbstractQNameStatementSupport<TypedefStatement, TypedefEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPEDEF).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addMandatory((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();

    public TypedefStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.TYPEDEF, StatementSupport.StatementPolicy.exactReplica(), config, SUBSTATEMENT_VALIDATOR);
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<QName, TypedefStatement, TypedefEffectiveStatement> stmt) {
        super.onFullDefinitionDeclared(stmt);
        StmtContext.Mutable parent = stmt.getParentContext();
        if (parent != null) {
            TypedefStatementSupport.checkConflict(parent, stmt);
            parent.addContext(ParserNamespaces.TYPE, (Object)((QName)stmt.getArgument()), stmt);
            StmtContext.Mutable grandParent = parent.getParentContext();
            if (grandParent != null) {
                ModelActionBuilder action = stmt.newInferenceAction(ModelProcessingPhase.FULL_DECLARATION);
                action.requiresCtx((StmtContext)grandParent.getRoot(), ModelProcessingPhase.FULL_DECLARATION);
                action.apply(new ModelActionBuilder.InferenceAction(){
                    final /* synthetic */ StmtContext val$grandParent;
                    final /* synthetic */ StmtContext.Mutable val$stmt;
                    {
                        this.val$grandParent = stmtContext;
                        this.val$stmt = mutable;
                    }

                    public void apply(ModelActionBuilder.InferenceContext ctx) {
                        TypedefStatementSupport.checkConflict(this.val$grandParent, this.val$stmt);
                    }

                    public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                    }
                });
            }
        }
    }

    protected TypedefStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createTypedef((QName)((QName)ctx.getArgument()), substatements);
    }

    protected TypedefStatement attachDeclarationReference(TypedefStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateTypedef((TypedefStatement)stmt, (DeclarationReference)reference);
    }

    protected TypedefEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, TypedefStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        TypedefStatement declared = (TypedefStatement)stmt.declared();
        Preconditions.checkState((!substatements.isEmpty() ? 1 : 0) != 0, (String)"Refusing to create empty typedef for %s", (Object)stmt.declared());
        TypeEffectiveStatement typeEffectiveStmt = (TypeEffectiveStatement)TypedefStatementSupport.findFirstStatement(substatements, TypeEffectiveStatement.class);
        String dflt = (String)TypedefStatementSupport.findFirstArgument(substatements, DefaultEffectiveStatement.class, null);
        SourceException.throwIf((boolean)EffectiveStmtUtils.hasDefaultValueMarkedWithIfFeature(stmt.yangVersion(), typeEffectiveStmt, dflt), stmt, (String)"Typedef '%s' has default value '%s' marked with an if-feature statement.", (Object[])new Object[]{stmt.argument(), dflt});
        return EffectiveStatements.createTypedef((TypedefStatement)declared, (int)TypedefStatementSupport.computeFlags(substatements), substatements);
    }

    private static void checkConflict(StmtContext<?, ?, ?> parent, StmtContext<QName, ?, ?> stmt) {
        QName arg = (QName)stmt.getArgument();
        StmtContext existing = (StmtContext)parent.getFromNamespace(ParserNamespaces.TYPE, (Object)arg);
        SourceException.throwIf((existing != null ? 1 : 0) != 0, stmt, (String)"Duplicate name for typedef %s", (Object[])new Object[]{arg});
    }

    private static int computeFlags(ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setStatus((Status)TypedefStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, (Object)Status.CURRENT)).toFlags();
    }
}

