/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.antlr;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.ir.IRArgument;
import org.opendaylight.yangtools.yang.ir.IRKeyword;
import org.opendaylight.yangtools.yang.ir.IRStatement;
import org.opendaylight.yangtools.yang.parser.antlr.YangStatementParser;

public final class IRSupport {
    private static final CharMatcher WHITESPACE_MATCHER = CharMatcher.whitespace();
    private final Map<String, IRArgument.Single> dquotArguments = new HashMap<String, IRArgument.Single>();
    private final Map<String, IRArgument.Single> squotArguments = new HashMap<String, IRArgument.Single>();
    private final Map<String, IRArgument.Single> uquotArguments = new HashMap<String, IRArgument.Single>();
    private final Map<String, IRArgument.Single> idenArguments = new HashMap<String, IRArgument.Single>();
    private final Map<String, IRKeyword.Unqualified> uqualKeywords = new HashMap<String, IRKeyword.Unqualified>();
    private final Map<Map.Entry<String, String>, IRKeyword.Qualified> qualKeywords = new HashMap<Map.Entry<String, String>, IRKeyword.Qualified>();
    private final Map<String, String> strings = new HashMap<String, String>();

    private IRSupport() {
    }

    public static @NonNull IRStatement createStatement(YangStatementParser.FileContext file) {
        return IRSupport.createStatement(file.statement());
    }

    public static @NonNull IRStatement createStatement(YangStatementParser.StatementContext stmt) {
        return new IRSupport().statementOf(stmt);
    }

    private @NonNull IRStatement statementOf(YangStatementParser.StatementContext stmt) {
        ParseTree firstChild = stmt.getChild(0);
        Verify.verify((boolean)(firstChild instanceof YangStatementParser.KeywordContext), (String)"Unexpected shape of %s", (Object)((Object)stmt));
        ParseTree keywordStart = firstChild.getChild(0);
        Verify.verify((boolean)(keywordStart instanceof TerminalNode), (String)"Unexpected keyword start %s", (Object)keywordStart);
        Token keywordToken = ((TerminalNode)keywordStart).getSymbol();
        IRKeyword.Unqualified keyword = switch (firstChild.getChildCount()) {
            case 1 -> this.uqualKeywords.computeIfAbsent(this.strOf(keywordToken), IRKeyword.Unqualified::of);
            case 3 -> this.qualKeywords.computeIfAbsent(Map.entry(this.strOf(keywordToken), this.strOf(firstChild.getChild(2))), entry -> IRKeyword.Qualified.of((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            default -> throw new VerifyException("Unexpected keyword " + firstChild);
        };
        IRArgument argument = this.createArgument(stmt);
        ImmutableList<IRStatement> statements = this.createStatements(stmt);
        int line = keywordToken.getLine();
        int column = keywordToken.getCharPositionInLine();
        return IRStatement.of((IRKeyword)keyword, (IRArgument)argument, (int)line, (int)column, statements);
    }

    private IRArgument createArgument(YangStatementParser.StatementContext stmt) {
        YangStatementParser.ArgumentContext argument = stmt.argument();
        if (argument == null) {
            return null;
        }
        return switch (argument.getChildCount()) {
            case 0 -> throw new VerifyException("Unexpected shape of " + argument);
            case 1 -> this.createSimple(argument);
            case 2 -> this.createQuoted(argument);
            default -> this.createConcatenation(argument);
        };
    }

    private IRArgument createConcatenation(YangStatementParser.ArgumentContext argument) {
        ArrayList<IRArgument.Single> parts = new ArrayList<IRArgument.Single>();
        block5: for (ParseTree child : argument.children) {
            Verify.verify((boolean)(child instanceof TerminalNode), (String)"Unexpected argument component %s", (Object)child);
            Token token = ((TerminalNode)child).getSymbol();
            switch (token.getType()) {
                case 4: 
                case 7: 
                case 17: 
                case 18: {
                    continue block5;
                }
                case 11: {
                    parts.add(this.createSingleQuoted(token));
                    continue block5;
                }
                case 10: {
                    parts.add(this.createDoubleQuoted(token));
                    continue block5;
                }
            }
            throw new VerifyException("Unexpected token " + token);
        }
        return IRArgument.of(parts);
    }

    private IRArgument.Single createQuoted(YangStatementParser.ArgumentContext argument) {
        ParseTree child = argument.getChild(0);
        Verify.verify((boolean)(child instanceof TerminalNode), (String)"Unexpected literal %s", (Object)child);
        Token token = ((TerminalNode)child).getSymbol();
        return switch (token.getType()) {
            case 10 -> this.createDoubleQuoted(token);
            case 11 -> this.createSingleQuoted(token);
            default -> throw new VerifyException("Unexpected token " + token);
        };
    }

    private IRArgument.Single createDoubleQuoted(Token token) {
        String str = this.intern(IRSupport.trimWhitespace(token.getText(), token.getCharPositionInLine() - 1));
        return this.dquotArguments.computeIfAbsent(str, IRArgument::doubleQuoted);
    }

    private IRArgument.Single createSimple(YangStatementParser.ArgumentContext argument) {
        ParseTree child = argument.getChild(0);
        if (child instanceof TerminalNode) {
            TerminalNode terminal = (TerminalNode)child;
            Token token = terminal.getSymbol();
            return switch (token.getType()) {
                case 5 -> this.idenArguments.computeIfAbsent(this.strOf(token), IRArgument::identifier);
                case 17, 18 -> IRArgument.empty();
                default -> throw new VerifyException("Unexpected token " + token);
            };
        }
        Verify.verify((boolean)(child instanceof YangStatementParser.UnquotedStringContext), (String)"Unexpected shape of %s", (Object)((Object)argument));
        return this.uquotArguments.computeIfAbsent(this.strOf(child), IRArgument::unquoted);
    }

    private IRArgument.Single createSingleQuoted(Token token) {
        return this.squotArguments.computeIfAbsent(this.strOf(token), IRArgument::singleQuoted);
    }

    private ImmutableList<IRStatement> createStatements(YangStatementParser.StatementContext stmt) {
        List<YangStatementParser.StatementContext> statements = stmt.statement();
        return statements.isEmpty() ? ImmutableList.of() : (ImmutableList)statements.stream().map(this::statementOf).collect(ImmutableList.toImmutableList());
    }

    private String strOf(ParseTree tree) {
        return this.intern(tree.getText());
    }

    private String strOf(Token token) {
        return this.intern(token.getText());
    }

    private String intern(String str) {
        return this.strings.computeIfAbsent(str, Function.identity());
    }

    @VisibleForTesting
    static String trimWhitespace(String str, int dquot) {
        int firstBrk = str.indexOf(10);
        if (firstBrk == -1) {
            return str;
        }
        int length = str.length();
        StringBuilder sb = new StringBuilder(length);
        sb.append(str, 0, IRSupport.trimTrailing(str, 0, firstBrk)).append('\n');
        int start = firstBrk + 1;
        int brk = str.indexOf(10, start);
        while (brk != -1) {
            IRSupport.trimLeadingAndAppend(sb, dquot, str, start, IRSupport.trimTrailing(str, start, brk)).append('\n');
            start = brk + 1;
            brk = str.indexOf(10, start);
        }
        return IRSupport.trimLeadingAndAppend(sb, dquot, str, start, length).toString();
    }

    private static StringBuilder trimLeadingAndAppend(StringBuilder sb, int dquot, String str, int start, int end) {
        int offset = start;
        int pos = 0;
        while (pos <= dquot) {
            if (offset == end) {
                return sb;
            }
            char ch = str.charAt(offset);
            if (ch == '\t') {
                pos += 8;
            } else {
                if (!WHITESPACE_MATCHER.matches(ch)) break;
                ++pos;
            }
            ++offset;
        }
        while (pos - 1 > dquot) {
            sb.append(' ');
            --pos;
        }
        return sb.append(str, offset, end);
    }

    private static int trimTrailing(String str, int start, int end) {
        int prev;
        int ret = end;
        while (ret > start && WHITESPACE_MATCHER.matches(str.charAt(prev = ret - 1))) {
            ret = prev;
        }
        return ret;
    }
}

