/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8528.parser;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.rfc8528.model.api.MountPointEffectiveStatement;
import org.opendaylight.yangtools.rfc8528.model.api.MountPointStatement;
import org.opendaylight.yangtools.rfc8528.model.api.SchemaMountStatements;
import org.opendaylight.yangtools.rfc8528.parser.MountPointEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc8528.parser.MountPointStatementImpl;
import org.opendaylight.yangtools.rfc8528.parser.RefMountPointStatement;
import org.opendaylight.yangtools.yang.common.MountPointLabel;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class MountPointStatementSupport
extends AbstractStatementSupport<MountPointLabel, MountPointStatement, MountPointEffectiveStatement> {
    private static final SubstatementValidator VALIDATOR = SubstatementValidator.builder((StatementDefinition)SchemaMountStatements.MOUNT_POINT).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).build();

    public MountPointStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)SchemaMountStatements.MOUNT_POINT, StatementSupport.StatementPolicy.copyDeclared((copy, current, substatements) -> ((MountPointLabel)copy.getArgument()).equals(current.getArgument()) && copy.history().isAugmenting() == current.history().isAugmenting() && copy.history().isAddedByUses() == current.history().isAddedByUses()), config, VALIDATOR);
    }

    public MountPointLabel parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return new MountPointLabel(StmtContextUtils.parseIdentifier(ctx, (String)value)).intern();
    }

    public MountPointLabel adaptArgumentValue(StmtContext<MountPointLabel, MountPointStatement, MountPointEffectiveStatement> ctx, QNameModule targetModule) {
        return new MountPointLabel(((MountPointLabel)ctx.getArgument()).qname().bindTo(targetModule)).intern();
    }

    public void onStatementAdded(StmtContext.Mutable<MountPointLabel, MountPointStatement, MountPointEffectiveStatement> stmt) {
        StatementDefinition parentDef = stmt.coerceParentContext().publicDefinition();
        SourceException.throwIf((YangStmtMapping.CONTAINER != parentDef && YangStmtMapping.LIST != parentDef ? 1 : 0) != 0, stmt, (String)"Mount points may only be defined at either a container or a list", (Object[])new Object[0]);
    }

    protected MountPointStatement createDeclared(BoundStmtCtx<MountPointLabel> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return new MountPointStatementImpl((MountPointLabel)ctx.getArgument(), substatements);
    }

    protected MountPointStatement attachDeclarationReference(MountPointStatement stmt, DeclarationReference reference) {
        return new RefMountPointStatement(stmt, reference);
    }

    protected MountPointEffectiveStatement createEffective(EffectiveStmtCtx.Current<MountPointLabel, MountPointStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new MountPointEffectiveStatementImpl(stmt, substatements);
    }
}

