/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.annotations.Beta;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;

public class TrackingLinkedBlockingQueue<E>
extends LinkedBlockingQueue<E> {
    private static final long serialVersionUID = 1L;
    private static final VarHandle LARGEST_QUEUE_SIZE;
    private volatile int largestQueueSize;

    public TrackingLinkedBlockingQueue() {
    }

    public TrackingLinkedBlockingQueue(@NonNull Collection<? extends E> c) {
        super(c);
    }

    public TrackingLinkedBlockingQueue(int capacity) {
        super(capacity);
    }

    @Beta
    public long getLargestQueueSize() {
        return this.largestQueueSize;
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (super.offer(e, timeout, unit)) {
            this.updateLargestQueueSize();
            return true;
        }
        return false;
    }

    @Override
    public boolean offer(E e) {
        if (super.offer(e)) {
            this.updateLargestQueueSize();
            return true;
        }
        return false;
    }

    @Override
    public void put(E e) throws InterruptedException {
        super.put(e);
        this.updateLargestQueueSize();
    }

    @Override
    public boolean add(E e) {
        boolean result = super.add(e);
        this.updateLargestQueueSize();
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        try {
            boolean bl = super.addAll(c);
            return bl;
        }
        finally {
            this.updateLargestQueueSize();
        }
    }

    private void updateLargestQueueSize() {
        int size = this.size();
        int largest = LARGEST_QUEUE_SIZE.getAcquire(this);
        while (largest < size) {
            largest = LARGEST_QUEUE_SIZE.compareAndExchangeRelease(this, largest, size);
        }
    }

    static {
        try {
            LARGEST_QUEUE_SIZE = MethodHandles.lookup().findVarHandle(TrackingLinkedBlockingQueue.class, "largestQueueSize", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

