/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

abstract class JSONStreamWriterContext {
    private final JSONStreamWriterContext parent;
    private final boolean mandatory;
    private final int depth;
    private boolean emittedMyself;
    private boolean inChild;

    protected JSONStreamWriterContext(JSONStreamWriterContext parent, boolean mandatory) {
        this.mandatory = mandatory;
        this.parent = parent;
        this.depth = parent != null ? parent.depth + 1 : 0;
    }

    final void writeChildJsonIdentifier(EffectiveModelContext schema, JsonWriter writer, QName qname) throws IOException {
        StringBuilder sb = new StringBuilder();
        QNameModule module = qname.getModule();
        if (!module.getNamespace().equals((Object)this.getNamespace())) {
            String name = schema.findModuleStatement(module).map(mod -> ((UnresolvedQName.Unqualified)mod.argument()).getLocalName()).orElseThrow(() -> new IllegalArgumentException("Could not find module for namespace " + module));
            sb.append(name).append(':');
        }
        sb.append(qname.getLocalName());
        writer.name(sb.toString());
    }

    protected final void writeMyJsonIdentifier(EffectiveModelContext schema, JsonWriter writer, QName qname) throws IOException {
        this.parent.writeChildJsonIdentifier(schema, writer, qname);
    }

    protected abstract @NonNull XMLNamespace getNamespace();

    protected abstract void emitStart(EffectiveModelContext var1, JsonWriter var2) throws IOException;

    protected abstract void emitEnd(JsonWriter var1) throws IOException;

    private void emitMyself(EffectiveModelContext schema, JsonWriter writer) throws IOException {
        if (!this.emittedMyself) {
            if (this.parent != null) {
                this.parent.emitMyself(schema, writer);
            }
            this.emitStart(schema, writer);
            this.emittedMyself = true;
        }
    }

    final void emittingChild(EffectiveModelContext schema, JsonWriter writer) throws IOException {
        Preconditions.checkState((!this.inChild ? 1 : 0) != 0, (Object)"Duplicate child encountered");
        this.emitMyself(schema, writer);
        this.inChild = true;
    }

    final JSONStreamWriterContext endNode(EffectiveModelContext schema, JsonWriter writer) throws IOException {
        if (this.inChild) {
            this.inChild = false;
            return this;
        }
        if (!this.emittedMyself && this.mandatory) {
            this.emitMyself(schema, writer);
        }
        if (this.emittedMyself) {
            this.emitEnd(writer);
        }
        return this.parent;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper;
    }
}

