/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.io.CharSource;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.SourceRepresentation;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureSet;
import org.opendaylight.yangtools.yang.model.repo.api.EffectiveModelContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactoryConfiguration;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaResolutionException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.StatementParserMode;
import org.opendaylight.yangtools.yang.model.repo.spi.GuavaSchemaSourceCache;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.spi.source.DelegatedYangTextSource;
import org.opendaylight.yangtools.yang.model.spi.source.URLYangTextSource;
import org.opendaylight.yangtools.yang.model.spi.source.YangIRSource;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.TextToIRTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangTextSchemaContextResolver
implements AutoCloseable,
SchemaSourceProvider<YangTextSource> {
    private static final Logger LOG = LoggerFactory.getLogger(YangTextSchemaContextResolver.class);
    private static final Duration SOURCE_LIFETIME = Duration.ofSeconds(60L);
    private final Collection<SourceIdentifier> requiredSources = new ConcurrentLinkedDeque<SourceIdentifier>();
    private final Multimap<SourceIdentifier, YangTextSource> texts = ArrayListMultimap.create();
    private final @GuardedBy(value={"this"}) Map<QNameModule, List<ImmutableSet<String>>> registeredFeatures = new HashMap<QNameModule, List<ImmutableSet<String>>>();
    private final AtomicReference<Optional<EffectiveModelContext>> currentSchemaContext = new AtomicReference(Optional.empty());
    private final GuavaSchemaSourceCache<YangIRSource> cache;
    private final SchemaSourceRegistry registry;
    private final SchemaRepository repository;
    private final Registration transReg;
    private volatile Object version;
    private volatile Object contextVersion = this.version = new Object();
    private @GuardedBy(value={"this"}) FeatureSet supportedFeatures = null;

    private YangTextSchemaContextResolver(SchemaRepository repository, SchemaSourceRegistry registry) {
        this.repository = Objects.requireNonNull(repository);
        this.registry = Objects.requireNonNull(registry);
        this.transReg = registry.registerSchemaSourceListener((SchemaSourceListener)TextToIRTransformer.create((SchemaRepository)repository, (SchemaSourceRegistry)registry));
        this.cache = GuavaSchemaSourceCache.createSoftCache((SchemaSourceRegistry)registry, YangIRSource.class, (Duration)SOURCE_LIFETIME);
    }

    public static @NonNull YangTextSchemaContextResolver create(String name) {
        SharedSchemaRepository sharedRepo = new SharedSchemaRepository(name);
        return new YangTextSchemaContextResolver((SchemaRepository)sharedRepo, (SchemaSourceRegistry)sharedRepo);
    }

    public static @NonNull YangTextSchemaContextResolver create(String name, YangParserFactory factory) {
        SharedSchemaRepository sharedRepo = new SharedSchemaRepository(name, factory);
        return new YangTextSchemaContextResolver((SchemaRepository)sharedRepo, (SchemaSourceRegistry)sharedRepo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull Registration registerSource(@NonNull YangTextSource source) throws SchemaSourceException, IOException, YangSyntaxErrorException {
        YangTextSource text;
        YangIRSource ast = TextToIRTransformer.transformText((YangTextSource)source);
        LOG.trace("Resolved source {} to source {}", (Object)source, (Object)ast);
        SourceIdentifier providedId = source.sourceId();
        final SourceIdentifier parsedId = ast.sourceId();
        if (!parsedId.equals((Object)providedId)) {
            if (!parsedId.name().equals((Object)providedId.name())) {
                LOG.info("Provided module name {} does not match actual text {}, corrected", (Object)providedId.toYangFilename(), (Object)parsedId.toYangFilename());
            } else {
                Revision sourceRev = providedId.revision();
                if (sourceRev != null) {
                    if (!sourceRev.equals((Object)parsedId.revision())) {
                        LOG.info("Provided module revision {} does not match actual text {}, corrected", (Object)providedId.toYangFilename(), (Object)parsedId.toYangFilename());
                    }
                } else {
                    LOG.debug("Expanded module {} to {}", (Object)providedId.toYangFilename(), (Object)parsedId.toYangFilename());
                }
            }
            text = new DelegatedYangTextSource(parsedId, (CharSource)source);
        } else {
            text = source;
        }
        YangTextSchemaContextResolver yangTextSchemaContextResolver = this;
        synchronized (yangTextSchemaContextResolver) {
            this.texts.put((Object)parsedId, (Object)text);
            LOG.debug("Populated {} with text", (Object)parsedId);
            final Registration reg = this.registry.registerSchemaSource((SchemaSourceProvider)this, PotentialSchemaSource.create((SourceIdentifier)parsedId, YangTextSource.class, (int)PotentialSchemaSource.Costs.IMMEDIATE.getValue()));
            this.requiredSources.add(parsedId);
            this.cache.schemaSourceEncountered((SourceRepresentation)ast);
            LOG.debug("Added source {} to schema context requirements", (Object)parsedId);
            this.version = new Object();
            return new AbstractRegistration(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void removeRegistration() {
                    YangTextSchemaContextResolver yangTextSchemaContextResolver = YangTextSchemaContextResolver.this;
                    synchronized (yangTextSchemaContextResolver) {
                        YangTextSchemaContextResolver.this.requiredSources.remove(parsedId);
                        LOG.trace("Removed source {} from schema context requirements", (Object)parsedId);
                        YangTextSchemaContextResolver.this.version = new Object();
                        reg.close();
                        YangTextSchemaContextResolver.this.texts.remove((Object)parsedId, (Object)text);
                    }
                }
            };
        }
    }

    public @NonNull Registration registerSource(@NonNull URL url) throws SchemaSourceException, IOException, YangSyntaxErrorException {
        String path = url.getPath();
        String fileName = path.substring(path.lastIndexOf(47) + 1);
        return this.registerSource((YangTextSource)new URLYangTextSource(YangTextSchemaContextResolver.guessSourceIdentifier(fileName), url, StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull Registration registerSupportedFeatures(QNameModule module, Set<String> features) {
        final QNameModule checked = Objects.requireNonNull(module);
        final ImmutableSet copy = ImmutableSet.copyOf(features);
        YangTextSchemaContextResolver yangTextSchemaContextResolver = this;
        synchronized (yangTextSchemaContextResolver) {
            this.version = new Object();
            this.supportedFeatures = null;
            this.registeredFeatures.computeIfAbsent(module, ignored -> new ArrayList()).add(copy);
        }
        return new AbstractRegistration(){

            protected void removeRegistration() {
                YangTextSchemaContextResolver.this.removeFeatures(checked, (ImmutableSet<String>)copy);
            }
        };
    }

    private synchronized void removeFeatures(QNameModule module, ImmutableSet<String> features) {
        List<ImmutableSet<String>> moduleFeatures = this.registeredFeatures.get(module);
        if (moduleFeatures != null && moduleFeatures.remove(features)) {
            if (moduleFeatures.isEmpty()) {
                this.registeredFeatures.remove(module);
            }
            this.supportedFeatures = null;
            this.version = new Object();
        }
    }

    private synchronized @Nullable FeatureSet getSupportedFeatures() {
        FeatureSet local = this.supportedFeatures;
        if (local == null && !this.registeredFeatures.isEmpty()) {
            FeatureSet.Builder builder = FeatureSet.builder();
            for (Map.Entry<QNameModule, List<ImmutableSet<String>>> entry : this.registeredFeatures.entrySet()) {
                for (ImmutableSet<String> features : entry.getValue()) {
                    builder.addModuleFeatures(entry.getKey(), features);
                }
            }
            this.supportedFeatures = local = builder.build();
        }
        return local;
    }

    private static SourceIdentifier guessSourceIdentifier(@NonNull String fileName) {
        try {
            return SourceIdentifier.ofYangFileName((String)fileName);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid file name format in '{}'", (Object)fileName, (Object)e);
            return new SourceIdentifier(fileName);
        }
    }

    public Optional<? extends EffectiveModelContext> getEffectiveModelContext() {
        return this.getEffectiveModelContext(StatementParserMode.DEFAULT_MODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<? extends EffectiveModelContext> getEffectiveModelContext(StatementParserMode statementParserMode) {
        Optional<EffectiveModelContext> sc;
        while (true) {
            Object sources;
            Object ver;
            Object cv = this.contextVersion;
            sc = this.currentSchemaContext.get();
            if (this.version == cv) {
                return sc;
            }
            if (cv != this.contextVersion) continue;
            do {
                ver = this.version;
                sources = ImmutableSet.copyOf(this.requiredSources);
            } while (ver != this.version);
            EffectiveModelContextFactory factory = this.repository.createEffectiveModelContextFactory(YangTextSchemaContextResolver.config(statementParserMode, this.getSupportedFeatures()));
            while (true) {
                ListenableFuture f = factory.createEffectiveModelContext((Collection)sources);
                try {
                    sc = Optional.of((EffectiveModelContext)f.get());
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Interrupted while assembling schema context", e);
                }
                catch (ExecutionException e) {
                    LOG.info("Failed to fully assemble schema context for {}", sources, (Object)e);
                    Throwable cause = e.getCause();
                    Verify.verify((boolean)(cause instanceof SchemaResolutionException));
                    sources = ((SchemaResolutionException)cause).getResolvedSources();
                    continue;
                }
                break;
            }
            LOG.debug("Resolved schema context for {}", sources);
            YangTextSchemaContextResolver yangTextSchemaContextResolver = this;
            synchronized (yangTextSchemaContextResolver) {
                if (this.contextVersion == cv) {
                    this.currentSchemaContext.set(sc);
                    this.contextVersion = ver;
                }
            }
            if (this.version != ver) break;
        }
        return sc;
    }

    public synchronized @NonNull FluentFuture<YangTextSource> getSource(SourceIdentifier sourceIdentifier) {
        Collection ret = this.texts.get((Object)sourceIdentifier);
        LOG.debug("Lookup {} result {}", (Object)sourceIdentifier, (Object)ret);
        if (ret.isEmpty()) {
            return FluentFutures.immediateFailedFluentFuture((Throwable)new MissingSchemaSourceException(sourceIdentifier, "URL for " + sourceIdentifier + " not registered"));
        }
        return FluentFutures.immediateFluentFuture((Object)((YangTextSource)ret.iterator().next()));
    }

    public synchronized Set<SourceIdentifier> getAvailableSources() {
        return ImmutableSet.copyOf((Collection)this.texts.keySet());
    }

    @Beta
    public synchronized Collection<YangTextSource> getSourceTexts(SourceIdentifier sourceIdentifier) {
        return ImmutableSet.copyOf((Collection)this.texts.get((Object)sourceIdentifier));
    }

    @Beta
    public EffectiveModelContext trySchemaContext() throws SchemaResolutionException, ExecutionException {
        return this.trySchemaContext(StatementParserMode.DEFAULT_MODE);
    }

    @Beta
    public EffectiveModelContext trySchemaContext(StatementParserMode statementParserMode) throws SchemaResolutionException, ExecutionException {
        ListenableFuture future = this.repository.createEffectiveModelContextFactory(YangTextSchemaContextResolver.config(statementParserMode, this.getSupportedFeatures())).createEffectiveModelContext((Collection)ImmutableSet.copyOf(this.requiredSources));
        try {
            return (EffectiveModelContext)future.get();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while waiting for SchemaContext assembly", e);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof SchemaResolutionException) {
                SchemaResolutionException sre = (SchemaResolutionException)throwable;
                throw sre;
            }
            throw e;
        }
    }

    @Override
    public void close() {
        this.transReg.close();
    }

    private static @NonNull SchemaContextFactoryConfiguration config(StatementParserMode statementParserMode, @Nullable FeatureSet supportedFeatures) {
        SchemaContextFactoryConfiguration.Builder builder = SchemaContextFactoryConfiguration.builder().setStatementParserMode(statementParserMode);
        if (supportedFeatures != null) {
            builder.setSupportedFeatures(supportedFeatures);
        }
        return builder.build();
    }
}

