/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

@Beta
public abstract class AbstractStatementSupport<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends StatementSupport<A, D, E> {
    private final SubstatementValidator substatementValidator;
    private final boolean retainDeclarationReference;

    protected AbstractStatementSupport(StatementDefinition publicDefinition, StatementSupport.StatementPolicy<A, D> policy, YangParserConfiguration config, @Nullable SubstatementValidator validator) {
        super(publicDefinition, policy);
        this.retainDeclarationReference = config.retainDeclarationReferences();
        this.substatementValidator = validator;
    }

    @Override
    protected final SubstatementValidator substatementValidator() {
        return this.substatementValidator;
    }

    @Override
    public final D createDeclared(BoundStmtCtx<A> ctx, Stream<DeclaredStatement<?>> substatements) {
        D stmt = this.createDeclared(ctx, (ImmutableList)substatements.collect(ImmutableList.toImmutableList()));
        return this.retainDeclarationReference ? this.attachDeclarationReference(stmt, ctx) : stmt;
    }

    @Override
    protected abstract @NonNull D createDeclared(@NonNull BoundStmtCtx<A> var1, @NonNull ImmutableList<DeclaredStatement<?>> var2);

    private @NonNull D attachDeclarationReference(@NonNull D stmt, @NonNull BoundStmtCtx<A> ctx) {
        DeclarationReference ref = ctx.sourceReference().declarationReference();
        return ref == null ? stmt : this.attachDeclarationReference(stmt, ref);
    }

    protected abstract @NonNull D attachDeclarationReference(@NonNull D var1, @NonNull DeclarationReference var2);

    @Override
    public final E createEffective(EffectiveStmtCtx.Current<A, D> stmt, Stream<StmtContext<?, ?, ?>> substatements) {
        return this.createEffective(stmt, this.buildEffectiveSubstatements(stmt, this.statementsToBuild(stmt, substatements)));
    }

    protected abstract @NonNull E createEffective( @NonNull EffectiveStmtCtx.Current<A, D> var1, @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> var2);

    @Override
    public E copyEffective(EffectiveStmtCtx.Current<A, D> stmt, E original) {
        return this.createEffective(stmt, ImmutableList.copyOf((Collection)original.effectiveSubstatements()));
    }

    protected Stream<? extends StmtContext<?, ?, ?>> statementsToBuild(EffectiveStmtCtx.Current<A, D> ctx, Stream<? extends StmtContext<?, ?, ?>> substatements) {
        return substatements;
    }

    public static final <E extends EffectiveStatement<?, ?>> @Nullable E findFirstStatement(Collection<? extends EffectiveStatement<?, ?>> statements, Class<E> type) {
        for (EffectiveStatement<?, ?> stmt : statements) {
            if (!type.isInstance(stmt)) continue;
            return (E)((EffectiveStatement)type.cast(stmt));
        }
        return null;
    }

    public static final <A, E extends EffectiveStatement<A, ?>> A findFirstArgument(Collection<? extends EffectiveStatement<?, ?>> statements, Class<@NonNull E> type, A defValue) {
        @Nullable E stmt = AbstractStatementSupport.findFirstStatement(statements, type);
        return (A)(stmt != null ? stmt.argument() : defValue);
    }

    protected @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> buildEffectiveSubstatements(EffectiveStmtCtx.Current<A, D> stmt, Stream<? extends StmtContext<?, ?, ?>> substatements) {
        return (ImmutableList)substatements.map(StmtContext::buildEffective).collect(ImmutableList.toImmutableList());
    }
}

