/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceBehaviourWithListeners;

final class SimpleNamespaceContext<K, V>
extends NamespaceBehaviourWithListeners<K, V> {
    private List<NamespaceBehaviourWithListeners.KeyedValueAddedListener<K>> listeners;
    private Collection<NamespaceBehaviourWithListeners.PredicateValueAddedListener<K, V>> predicateListeners;

    SimpleNamespaceContext(NamespaceBehaviour<K, V> delegate) {
        super(delegate);
    }

    @Override
    void addListener(NamespaceBehaviourWithListeners.KeyedValueAddedListener<K> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<NamespaceBehaviourWithListeners.KeyedValueAddedListener<K>>();
        }
        this.listeners.add(listener);
    }

    @Override
    void addListener(NamespaceBehaviourWithListeners.PredicateValueAddedListener<K, V> listener) {
        if (this.predicateListeners == null) {
            this.predicateListeners = new ArrayList<NamespaceBehaviourWithListeners.PredicateValueAddedListener<K, V>>();
        }
        this.predicateListeners.add(listener);
    }

    @Override
    public void addTo(NamespaceBehaviour.NamespaceStorageNode storage, K key, V value) {
        this.delegate.addTo(storage, key, value);
        if (this.listeners != null) {
            this.notifyListeners(storage, this.listeners.iterator(), value);
            if (this.listeners != null && this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
        if (this.predicateListeners != null) {
            Iterator<NamespaceBehaviourWithListeners.PredicateValueAddedListener<K, V>> it = this.predicateListeners.iterator();
            while (it.hasNext()) {
                if (!it.next().onValueAdded(key, value)) continue;
                it.remove();
            }
            if (this.predicateListeners != null && this.predicateListeners.isEmpty()) {
                this.predicateListeners = null;
            }
        }
        this.notifyDerivedNamespaces(storage, key, value);
    }
}

