/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;

public class OperationFailedException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final ImmutableList<RpcError> errorList;

    public OperationFailedException(String message, Throwable cause) {
        super(Objects.requireNonNull(message), cause);
        this.errorList = null;
    }

    public OperationFailedException(String message, RpcError error) {
        super(Objects.requireNonNull(message));
        this.errorList = ImmutableList.of((Object)error);
    }

    public OperationFailedException(String message, Throwable cause, Collection<RpcError> errors) {
        super(Objects.requireNonNull(message), cause);
        this.errorList = errors.isEmpty() ? null : ImmutableList.copyOf(errors);
    }

    public OperationFailedException(String message, Collection<? extends RpcError> errors) {
        super(Objects.requireNonNull(message));
        this.errorList = ImmutableList.copyOf(errors);
    }

    public OperationFailedException(String message, RpcError ... errors) {
        this(message, (Throwable)null, errors);
    }

    public OperationFailedException(String message, Throwable cause, RpcError ... errors) {
        this(message, cause, Arrays.asList(errors));
    }

    public List<RpcError> getErrorList() {
        return this.errorList != null ? this.errorList : ImmutableList.of((Object)RpcResultBuilder.newError(ErrorType.APPLICATION, null, this.getMessage(), null, null, this.getCause()));
    }

    @Override
    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("message", (Object)this.getMessage()).add("errorList", this.getErrorList());
    }
}

