/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.impl.context;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.impl.context.AbstractContext;
import org.opendaylight.yangtools.yang.data.util.impl.context.AbstractPathMixinContext;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class ChoiceContext
extends AbstractPathMixinContext {
    private final ImmutableMap<YangInstanceIdentifier.NodeIdentifier, AbstractContext> byArg;
    private final ImmutableMap<QName, AbstractContext> byQName;
    private final ImmutableMap<AbstractContext, QName> childToCase;

    ChoiceContext(ChoiceSchemaNode schema) {
        super((DataSchemaNode)schema);
        ImmutableMap.Builder childToCaseBuilder = ImmutableMap.builder();
        ImmutableMap.Builder byQNameBuilder = ImmutableMap.builder();
        ImmutableMap.Builder byArgBuilder = ImmutableMap.builder();
        for (CaseSchemaNode caze : schema.getCases()) {
            for (DataSchemaNode cazeChild : caze.getChildNodes()) {
                AbstractContext childOp = AbstractContext.of(cazeChild);
                byArgBuilder.put((Object)childOp.getPathStep(), (Object)childOp);
                childToCaseBuilder.put((Object)childOp, (Object)caze.getQName());
                for (QName qname : childOp.qnameIdentifiers()) {
                    byQNameBuilder.put((Object)qname, (Object)childOp);
                }
            }
        }
        this.childToCase = childToCaseBuilder.build();
        this.byQName = byQNameBuilder.build();
        this.byArg = byArgBuilder.build();
    }

    @Override
    public AbstractContext childByArg(YangInstanceIdentifier.PathArgument arg) {
        return (AbstractContext)this.byArg.get((Object)Objects.requireNonNull(arg));
    }

    @Override
    public AbstractContext childByQName(QName child) {
        return (AbstractContext)this.byQName.get((Object)Objects.requireNonNull(child));
    }

    @Override
    ImmutableSet<QName> qnameIdentifiers() {
        return this.byQName.keySet();
    }

    @Override
    public AbstractContext enterChild(SchemaInferenceStack stack, QName qname) {
        return this.pushToStack(stack, this.childByQName(qname));
    }

    @Override
    public AbstractContext enterChild(SchemaInferenceStack stack, YangInstanceIdentifier.PathArgument arg) {
        return this.pushToStack(stack, this.childByArg(arg));
    }

    @Override
    void pushToStack(SchemaInferenceStack stack) {
        stack.enterChoice(this.dataSchemaNode.getQName());
    }

    private AbstractContext pushToStack(SchemaInferenceStack stack, AbstractContext child) {
        Objects.requireNonNull(stack);
        if (child != null) {
            QName caseName = (QName)Verify.verifyNotNull((Object)((QName)this.childToCase.get((Object)child)), (String)"No case statement for %s in %s", (Object[])new Object[]{child, this});
            stack.enterSchemaTree(caseName);
            child.pushToStack(stack);
        }
        return child;
    }
}

