/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.impl.context;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContext;
import org.opendaylight.yangtools.yang.data.util.impl.context.ChoiceContext;
import org.opendaylight.yangtools.yang.data.util.impl.context.ContainerContext;
import org.opendaylight.yangtools.yang.data.util.impl.context.LeafContext;
import org.opendaylight.yangtools.yang.data.util.impl.context.LeafListContext;
import org.opendaylight.yangtools.yang.data.util.impl.context.ListContext;
import org.opendaylight.yangtools.yang.data.util.impl.context.MapContext;
import org.opendaylight.yangtools.yang.data.util.impl.context.OpaqueContext;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractContext
implements DataSchemaContext {
    private final YangInstanceIdentifier.NodeIdentifier pathStep;
    final @NonNull DataSchemaNode dataSchemaNode;

    AbstractContext(YangInstanceIdentifier.NodeIdentifier pathStep, DataSchemaNode dataSchemaNode) {
        this.dataSchemaNode = Objects.requireNonNull(dataSchemaNode);
        this.pathStep = pathStep;
    }

    @Override
    public final DataSchemaNode dataSchemaNode() {
        return this.dataSchemaNode;
    }

    @Override
    public final YangInstanceIdentifier.NodeIdentifier pathStep() {
        return this.pathStep;
    }

    ImmutableSet<QName> qnameIdentifiers() {
        return ImmutableSet.of((Object)this.dataSchemaNode.getQName());
    }

    void pushToStack(@NonNull SchemaInferenceStack stack) {
        stack.enterSchemaTree(this.dataSchemaNode.getQName());
    }

    static AbstractContext fromSchemaAndQNameChecked(DataNodeContainer schema, QName child) {
        return AbstractContext.lenientOf(AbstractContext.findChildSchemaNode(schema, child));
    }

    private static DataSchemaNode findChildSchemaNode(DataNodeContainer parent, QName child) {
        DataSchemaNode potential = parent.dataChildByName(child);
        return potential == null ? AbstractContext.findChoice(Iterables.filter((Iterable)parent.getChildNodes(), ChoiceSchemaNode.class), child) : potential;
    }

    private static ChoiceSchemaNode findChoice(Iterable<ChoiceSchemaNode> choices, QName child) {
        for (ChoiceSchemaNode choice : choices) {
            for (CaseSchemaNode caze : choice.getCases()) {
                if (AbstractContext.findChildSchemaNode((DataNodeContainer)caze, child) == null) continue;
                return choice;
            }
        }
        return null;
    }

    public static @NonNull AbstractContext of(@NonNull DataSchemaNode schema) {
        if (schema instanceof ContainerLike) {
            ContainerLike containerLike = (ContainerLike)schema;
            return new ContainerContext(containerLike);
        }
        if (schema instanceof ListSchemaNode) {
            ListSchemaNode list = (ListSchemaNode)schema;
            return AbstractContext.fromListSchemaNode(list);
        }
        if (schema instanceof LeafSchemaNode) {
            LeafSchemaNode leaf = (LeafSchemaNode)schema;
            return new LeafContext(leaf);
        }
        if (schema instanceof ChoiceSchemaNode) {
            ChoiceSchemaNode choice = (ChoiceSchemaNode)schema;
            return new ChoiceContext(choice);
        }
        if (schema instanceof LeafListSchemaNode) {
            LeafListSchemaNode leafList = (LeafListSchemaNode)schema;
            return new LeafListContext(leafList);
        }
        if (schema instanceof AnydataSchemaNode) {
            AnydataSchemaNode anydata = (AnydataSchemaNode)schema;
            return new OpaqueContext((DataSchemaNode)anydata);
        }
        if (schema instanceof AnyxmlSchemaNode) {
            AnyxmlSchemaNode anyxml = (AnyxmlSchemaNode)schema;
            return new OpaqueContext((DataSchemaNode)anyxml);
        }
        throw new IllegalStateException("Unhandled schema " + schema);
    }

    private static @Nullable AbstractContext lenientOf(@Nullable DataSchemaNode schema) {
        if (schema instanceof ContainerLike) {
            ContainerLike containerLike = (ContainerLike)schema;
            return new ContainerContext(containerLike);
        }
        if (schema instanceof ListSchemaNode) {
            ListSchemaNode list = (ListSchemaNode)schema;
            return AbstractContext.fromListSchemaNode(list);
        }
        if (schema instanceof LeafSchemaNode) {
            LeafSchemaNode leaf = (LeafSchemaNode)schema;
            return new LeafContext(leaf);
        }
        if (schema instanceof ChoiceSchemaNode) {
            ChoiceSchemaNode choice = (ChoiceSchemaNode)schema;
            return new ChoiceContext(choice);
        }
        if (schema instanceof LeafListSchemaNode) {
            LeafListSchemaNode leafList = (LeafListSchemaNode)schema;
            return new LeafListContext(leafList);
        }
        if (schema instanceof AnydataSchemaNode) {
            AnydataSchemaNode anydata = (AnydataSchemaNode)schema;
            return new OpaqueContext((DataSchemaNode)anydata);
        }
        if (schema instanceof AnyxmlSchemaNode) {
            AnyxmlSchemaNode anyxml = (AnyxmlSchemaNode)schema;
            return new OpaqueContext((DataSchemaNode)anyxml);
        }
        return null;
    }

    private static @NonNull AbstractContext fromListSchemaNode(ListSchemaNode potential) {
        List keyDefinition = potential.getKeyDefinition();
        if (keyDefinition.isEmpty()) {
            return new ListContext(potential);
        }
        return new MapContext(potential);
    }
}

