/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class NormalizedNodeStreamWriterStack
implements LeafrefResolver {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizedNodeStreamWriterStack.class);
    private final Deque<DataSchemaNode> schemaStack = new ArrayDeque<DataSchemaNode>();
    private final SchemaInferenceStack dataTree;
    private final DataNodeContainer root;

    private NormalizedNodeStreamWriterStack(EffectiveModelContext context) {
        this.dataTree = SchemaInferenceStack.of((EffectiveModelContext)context);
        this.root = (DataNodeContainer)Objects.requireNonNull(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NormalizedNodeStreamWriterStack(SchemaInferenceStack dataTree) {
        this.dataTree = Objects.requireNonNull(dataTree);
        if (!dataTree.isEmpty()) {
            DataNodeContainer container;
            EffectiveStatement current = dataTree.currentStatement();
            if (!(current instanceof DataNodeContainer)) throw new IllegalArgumentException("Cannot instantiate on " + current);
            this.root = container = (DataNodeContainer)current;
            return;
        } else {
            this.root = dataTree.modelContext();
        }
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(EffectiveStatementInference root) {
        return new NormalizedNodeStreamWriterStack(SchemaInferenceStack.ofInference((EffectiveStatementInference)root));
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(SchemaInferenceStack.Inference root) {
        return new NormalizedNodeStreamWriterStack(root.toSchemaInferenceStack());
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(EffectiveModelContext context) {
        return new NormalizedNodeStreamWriterStack(context);
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(EffectiveModelContext context, SchemaNodeIdentifier.Absolute path) {
        return new NormalizedNodeStreamWriterStack(SchemaInferenceStack.of((EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)path));
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(EffectiveModelContext context, YangInstanceIdentifier path) {
        return new NormalizedNodeStreamWriterStack(((DataSchemaContextTree.NodeAndStack)DataSchemaContextTree.from(context).enterPath(path).orElseThrow()).stack());
    }

    public static @NonNull NormalizedNodeStreamWriterStack ofOperation(EffectiveModelContext context, SchemaNodeIdentifier.Absolute operation, QName qname) {
        SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)operation);
        EffectiveStatement current = stack.currentStatement();
        Preconditions.checkArgument((current instanceof RpcEffectiveStatement || current instanceof ActionEffectiveStatement ? 1 : 0) != 0, (String)"Path %s resolved into non-operation %s", (Object)operation, (Object)current);
        stack.enterSchemaTree(qname);
        return new NormalizedNodeStreamWriterStack(stack);
    }

    public TypeDefinition<?> resolveLeafref(LeafrefTypeDefinition type) {
        return this.dataTree.resolveLeafref(type);
    }

    public Object getParent() {
        DataSchemaNode schema = this.schemaStack.peek();
        return schema == null ? this.root : schema;
    }

    private @NonNull SchemaNode enterDataTree(YangInstanceIdentifier.PathArgument name) {
        QName qname = name.getNodeType();
        DataTreeEffectiveStatement stmt = this.dataTree.enterDataTree(qname);
        if (!(stmt instanceof SchemaNode)) {
            throw new VerifyException("Unexpected result " + stmt);
        }
        SchemaNode ret = (SchemaNode)stmt;
        Object object = this.getParent();
        if (object instanceof ChoiceSchemaNode) {
            ChoiceSchemaNode choice = (ChoiceSchemaNode)object;
            DataSchemaNode check = choice.findDataSchemaChild(qname).orElse(null);
            Verify.verify((check == ret ? 1 : 0) != 0, (String)"Data tree result %s does not match choice result %s", (Object)ret, (Object)check);
        }
        return ret;
    }

    private <T extends DataSchemaNode> @NonNull T enterDataTree(YangInstanceIdentifier.PathArgument name, @NonNull Class<T> expectedClass, @NonNull String humanString) {
        DataSchemaNode casted;
        SchemaNode schema = this.enterDataTree(name);
        try {
            casted = (DataSchemaNode)expectedClass.cast(schema);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Node " + schema + " is not " + humanString, e);
        }
        this.schemaStack.push(casted);
        return (T)casted;
    }

    public void startList(YangInstanceIdentifier.PathArgument name) {
        this.enterDataTree(name, ListSchemaNode.class, "a list");
    }

    public void startListItem(YangInstanceIdentifier.PathArgument name) throws IOException {
        Object object = this.getParent();
        if (!(object instanceof ListSchemaNode)) {
            throw new IllegalArgumentException("List item is not appropriate");
        }
        ListSchemaNode parentList = (ListSchemaNode)object;
        this.schemaStack.push((DataSchemaNode)parentList);
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        this.enterDataTree((YangInstanceIdentifier.PathArgument)name, LeafSchemaNode.class, "a leaf");
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name) {
        this.enterDataTree((YangInstanceIdentifier.PathArgument)name, LeafListSchemaNode.class, "a leaf-list");
    }

    private @NonNull LeafListSchemaNode leafSetEntryNode(QName qname) {
        Object parent = this.getParent();
        if (parent instanceof LeafListSchemaNode) {
            LeafListSchemaNode leafList = (LeafListSchemaNode)parent;
            return leafList;
        }
        if (parent instanceof DataNodeContainer) {
            DataNodeContainer parentContainer = (DataNodeContainer)parent;
            DataSchemaNode child = parentContainer.dataChildByName(qname);
            if (child instanceof LeafListSchemaNode) {
                LeafListSchemaNode childLeafList = (LeafListSchemaNode)child;
                return childLeafList;
            }
            throw new IllegalArgumentException("Node " + child + " is neither a leaf-list nor currently in a leaf-list");
        }
        throw new IllegalArgumentException("Cannot lookup " + qname + " in parent " + parent);
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) {
        this.schemaStack.push((DataSchemaNode)this.leafSetEntryNode(name.getNodeType()));
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name) {
        LOG.debug("Enter choice {}", (Object)name);
        ChoiceEffectiveStatement stmt = this.dataTree.enterChoice(name.getNodeType());
        if (!(stmt instanceof ChoiceSchemaNode)) {
            throw new VerifyException("Node " + stmt + " is not a choice");
        }
        ChoiceSchemaNode choice = (ChoiceSchemaNode)stmt;
        this.schemaStack.push((DataSchemaNode)choice);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public @NonNull ContainerLike startContainerNode(YangInstanceIdentifier.NodeIdentifier name) {
        LOG.debug("Enter container {}", (Object)name);
        if (!this.schemaStack.isEmpty()) return this.enterDataTree((YangInstanceIdentifier.PathArgument)name, ContainerLike.class, "a container");
        DataNodeContainer dataNodeContainer = this.root;
        if (!(dataNodeContainer instanceof NotificationDefinition)) return this.enterDataTree((YangInstanceIdentifier.PathArgument)name, ContainerLike.class, "a container");
        NotificationDefinition notification = (NotificationDefinition)dataNodeContainer;
        if (!name.getNodeType().equals((Object)notification.getQName())) return this.enterDataTree((YangInstanceIdentifier.PathArgument)name, ContainerLike.class, "a container");
        ContainerLike schema = notification.toContainerLike();
        this.schemaStack.push((DataSchemaNode)schema);
        return schema;
    }

    public void startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name) {
        this.enterDataTree((YangInstanceIdentifier.PathArgument)name, AnyxmlSchemaNode.class, "anyxml");
    }

    public void startAnydataNode(YangInstanceIdentifier.NodeIdentifier name) {
        this.enterDataTree((YangInstanceIdentifier.PathArgument)name, AnydataSchemaNode.class, "anydata");
    }

    public Object endNode() {
        DataSchemaNode ret = this.schemaStack.pop();
        if (this.getParent() != ret) {
            this.dataTree.exit();
        }
        return ret;
    }
}

