/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.AbstractNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AnyXmlNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AnydataNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.CaseNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ChoiceNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ContainerNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.DuplicateChildNodeRejectedException;
import org.opendaylight.yangtools.yang.data.util.LeafListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class CompositeNodeDataWithSchema<T extends DataSchemaNode>
extends AbstractNodeDataWithSchema<T> {
    private final List<AbstractNodeDataWithSchema<?>> children = new ArrayList();

    public CompositeNodeDataWithSchema(T schema) {
        super(schema);
    }

    public static @NonNull CompositeNodeDataWithSchema<?> of(DataSchemaNode schema) {
        if (schema instanceof ListSchemaNode) {
            ListSchemaNode list = (ListSchemaNode)schema;
            return new ListNodeDataWithSchema(list);
        }
        if (schema instanceof LeafListSchemaNode) {
            LeafListSchemaNode leafList = (LeafListSchemaNode)schema;
            return new LeafListNodeDataWithSchema(leafList);
        }
        if (schema instanceof ContainerLike) {
            ContainerLike containerLike = (ContainerLike)schema;
            return new ContainerNodeDataWithSchema(containerLike);
        }
        return new CompositeNodeDataWithSchema<DataSchemaNode>(schema);
    }

    void addChild(AbstractNodeDataWithSchema<?> newChild) {
        this.children.add(newChild);
    }

    public final AbstractNodeDataWithSchema<?> addChild(Deque<DataSchemaNode> schemas, ChildReusePolicy policy) {
        Preconditions.checkArgument((!schemas.isEmpty() ? 1 : 0) != 0, (Object)"Expecting at least one schema");
        DataSchemaNode schema = schemas.pop();
        if (schemas.isEmpty()) {
            return this.addChild(schema, policy);
        }
        DataSchemaNode choiceCandidate = schema;
        Preconditions.checkArgument((boolean)(choiceCandidate instanceof ChoiceSchemaNode), (String)"Expected node of type ChoiceNode but was %s", choiceCandidate.getClass());
        ChoiceSchemaNode choiceNode = (ChoiceSchemaNode)choiceCandidate;
        DataSchemaNode caseCandidate = schemas.pop();
        Preconditions.checkArgument((boolean)(caseCandidate instanceof CaseSchemaNode), (String)"Expected node of type ChoiceCaseNode but was %s", caseCandidate.getClass());
        CaseSchemaNode caseNode = (CaseSchemaNode)caseCandidate;
        CaseNodeDataWithSchema caseNodeDataWithSchema = CompositeNodeDataWithSchema.findChoice(this.children, choiceCandidate, caseCandidate);
        if (caseNodeDataWithSchema == null) {
            ChoiceNodeDataWithSchema choiceNodeDataWithSchema = new ChoiceNodeDataWithSchema(choiceNode);
            this.children.add(choiceNodeDataWithSchema);
            caseNodeDataWithSchema = choiceNodeDataWithSchema.addCompositeChild(caseNode, ChildReusePolicy.NOOP);
        }
        return caseNodeDataWithSchema.addChild(schemas, policy);
    }

    private AbstractNodeDataWithSchema<?> addChild(DataSchemaNode schema, ChildReusePolicy policy) {
        AbstractNodeDataWithSchema<?> newChild = this.addSimpleChild(schema, policy);
        return newChild == null ? this.addCompositeChild(schema, policy) : newChild;
    }

    private AbstractNodeDataWithSchema<?> addSimpleChild(DataSchemaNode schema, ChildReusePolicy policy) {
        SimpleNodeDataWithSchema newChild;
        if (schema instanceof LeafSchemaNode) {
            LeafSchemaNode leaf = (LeafSchemaNode)schema;
            newChild = new LeafNodeDataWithSchema(leaf);
        } else if (schema instanceof AnyxmlSchemaNode) {
            AnyxmlSchemaNode anyxml = (AnyxmlSchemaNode)schema;
            newChild = new AnyXmlNodeDataWithSchema(anyxml);
        } else if (schema instanceof AnydataSchemaNode) {
            AnydataSchemaNode anydata = (AnydataSchemaNode)schema;
            newChild = new AnydataNodeDataWithSchema(anydata);
        } else {
            return null;
        }
        this.addChild(newChild);
        return newChild;
    }

    private static CaseNodeDataWithSchema findChoice(Collection<AbstractNodeDataWithSchema<?>> childNodes, DataSchemaNode choiceCandidate, DataSchemaNode caseCandidate) {
        if (childNodes != null) {
            for (AbstractNodeDataWithSchema<?> nodeDataWithSchema : childNodes) {
                if (!(nodeDataWithSchema instanceof ChoiceNodeDataWithSchema)) continue;
                ChoiceNodeDataWithSchema childChoice = (ChoiceNodeDataWithSchema)nodeDataWithSchema;
                if (!nodeDataWithSchema.getSchema().getQName().equals((Object)choiceCandidate.getQName())) continue;
                CaseNodeDataWithSchema casePrevious = childChoice.getCase();
                Preconditions.checkArgument((boolean)((CaseSchemaNode)casePrevious.getSchema()).getQName().equals((Object)caseCandidate.getQName()), (String)"Data from case %s are specified but other data from case %s were specified earlier. Data aren't from the same case.", (Object)caseCandidate.getQName(), (Object)((CaseSchemaNode)casePrevious.getSchema()).getQName());
                return casePrevious;
            }
        }
        return null;
    }

    AbstractNodeDataWithSchema<?> addCompositeChild(DataSchemaNode schema, ChildReusePolicy policy) {
        return this.addCompositeChild(CompositeNodeDataWithSchema.of(schema), policy);
    }

    final AbstractNodeDataWithSchema<?> addCompositeChild(CompositeNodeDataWithSchema<?> newChild, ChildReusePolicy policy) {
        return policy.appendChild(this.children, newChild);
    }

    protected final int childSizeHint() {
        return this.children.size();
    }

    @Override
    public void write(NormalizedNodeStreamWriter writer, NormalizedNodeStreamWriter.MetadataExtension metaWriter) throws IOException {
        for (AbstractNodeDataWithSchema<?> child : this.children) {
            child.write(writer, metaWriter);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Beta
    public static enum ChildReusePolicy {
        NOOP,
        REJECT{

            @Override
            AbstractNodeDataWithSchema<?> appendChild(Collection<AbstractNodeDataWithSchema<?>> view, AbstractNodeDataWithSchema<?> newChild) {
                Object childSchema = newChild.getSchema();
                AbstractNodeDataWithSchema<?> existing = 1.findExistingChild(view, childSchema);
                if (existing != null) {
                    throw new DuplicateChildNodeRejectedException("Duplicate child " + childSchema.getQName());
                }
                return super.appendChild(view, newChild);
            }
        }
        ,
        REUSE{

            @Override
            AbstractNodeDataWithSchema<?> appendChild(Collection<AbstractNodeDataWithSchema<?>> view, AbstractNodeDataWithSchema<?> newChild) {
                AbstractNodeDataWithSchema<?> existing = 2.findExistingChild(view, newChild.getSchema());
                return existing != null ? existing : super.appendChild(view, newChild);
            }
        };


        AbstractNodeDataWithSchema<?> appendChild(Collection<AbstractNodeDataWithSchema<?>> view, AbstractNodeDataWithSchema<?> newChild) {
            view.add(newChild);
            return newChild;
        }

        static @Nullable AbstractNodeDataWithSchema<?> findExistingChild(Collection<AbstractNodeDataWithSchema<?>> view, DataSchemaNode childSchema) {
            for (AbstractNodeDataWithSchema<?> existing : view) {
                if (!childSchema.equals(existing.getSchema())) continue;
                return existing;
            }
            return null;
        }
    }
}

