/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PrettyTreeIndent {
    private static final Logger LOG = LoggerFactory.getLogger(PrettyTreeIndent.class);
    private static final int DEFAULT_INDENT = 4;
    private static final int INDENT_STRINGS_SIZE = 16;
    private static final String[] INDENT_STRINGS;

    private PrettyTreeIndent() {
    }

    static void indent(StringBuilder sb, int depth) {
        int remaining;
        for (remaining = depth; remaining >= 16; remaining -= 16) {
            sb.append(INDENT_STRINGS[15]);
        }
        sb.append(INDENT_STRINGS[remaining]);
    }

    static {
        int indent = Integer.getInteger("org.opendaylight.yangtools.concepts.pretty-tree-indent", 4);
        if (indent < 1) {
            LOG.warn("Invalid pretty-tree-indent {}, using {} instead", (Object)indent, (Object)4);
            indent = 4;
        } else if (indent != 4) {
            LOG.info("Using pretty-tree-indent {}", (Object)indent);
        }
        String one = " ".repeat(indent);
        String[] strings = new String[16];
        for (int i = 0; i < 16; ++i) {
            strings[i] = one.repeat(i).intern();
        }
        INDENT_STRINGS = strings;
    }
}

