/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.opendaylight.yangtools.yang.data.impl.codec.CompiledPatternContext;
import org.opendaylight.yangtools.yang.data.impl.codec.StringStringCodec;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StringPatternCheckingCodec
extends StringStringCodec {
    private static final Logger LOG = LoggerFactory.getLogger(StringPatternCheckingCodec.class);
    private final ImmutableList<CompiledPatternContext> patterns;

    StringPatternCheckingCodec(StringTypeDefinition typeDef) {
        super(typeDef);
        List constraints = typeDef.getPatternConstraints();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)constraints.size());
        for (PatternConstraint yangPattern : typeDef.getPatternConstraints()) {
            try {
                builder.add((Object)new CompiledPatternContext(yangPattern));
            }
            catch (PatternSyntaxException e) {
                LOG.debug("Unable to compile {} pattern, excluding it from validation.", (Object)yangPattern, (Object)e);
            }
        }
        this.patterns = builder.build();
    }

    @Override
    void validate(String str) {
        super.validate(str);
        for (CompiledPatternContext pattern : this.patterns) {
            pattern.validate(str);
        }
    }
}

