/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.codec.BooleanCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;

@Beta
public final class BooleanStringCodec
extends TypeDefinitionAwareCodec<Boolean, BooleanTypeDefinition>
implements BooleanCodec<String> {
    private BooleanStringCodec(BooleanTypeDefinition typeDef) {
        super(Boolean.class, typeDef);
    }

    public static @NonNull BooleanStringCodec from(BooleanTypeDefinition typeDef) {
        return new BooleanStringCodec(typeDef);
    }

    protected Boolean deserializeImpl(String product) {
        return switch (product) {
            case "true" -> Boolean.TRUE;
            case "false" -> Boolean.FALSE;
            default -> throw new IllegalArgumentException("Invalid value '" + product + "' for boolean type. Allowed values are 'true' and 'false'");
        };
    }

    protected String serializeImpl(Boolean input) {
        return input.toString();
    }
}

