/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8040.parser;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataConstants;
import org.opendaylight.yangtools.rfc8040.parser.OperationsCreateLeafStatements;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class OperationsValidateModuleAction
implements ModelActionBuilder.InferenceAction {
    private final ModelActionBuilder.Prerequisite<? extends StmtContext.Mutable<?, ?, ?>> prereq;

    private OperationsValidateModuleAction(ModelActionBuilder.Prerequisite<? extends StmtContext.Mutable<?, ?, ?>> prereq) {
        this.prereq = Objects.requireNonNull(prereq);
    }

    static void applyTo(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull StmtContext.Mutable<?, ?, ?> module) {
        if (module.producesDeclared(ModuleStatement.class) && YangDataConstants.MODULE_NAME.equals(module.argument())) {
            ModelActionBuilder action = module.newInferenceAction(ModelProcessingPhase.FULL_DECLARATION);
            ModelActionBuilder.Prerequisite prereq = action.mutatesEffectiveCtx(module);
            action.apply((ModelActionBuilder.InferenceAction)new OperationsValidateModuleAction(prereq));
        }
    }

    public void apply(ModelActionBuilder.InferenceContext ctx) {
        StmtContext.Mutable moduleCtx = (StmtContext.Mutable)this.prereq.resolve(ctx);
        QNameModule moduleQName = (QNameModule)moduleCtx.namespaceItem(ParserNamespaces.MODULECTX_TO_QNAME, (Object)moduleCtx);
        if (!YangDataConstants.RFC8040_MODULE.equals((Object)moduleQName)) {
            return;
        }
        for (StmtContext.Mutable moduleSub : moduleCtx.mutableDeclaredSubstatements()) {
            if (!moduleSub.producesDeclared(GroupingStatement.class) || !"restconf".equals(moduleSub.rawArgument())) continue;
            for (StmtContext.Mutable grpSub : moduleSub.mutableDeclaredSubstatements()) {
                if (!grpSub.producesDeclared(ContainerStatement.class) || !"restconf".equals(grpSub.rawArgument())) continue;
                for (StmtContext.Mutable contSub : grpSub.mutableDeclaredSubstatements()) {
                    if (!contSub.producesDeclared(ContainerStatement.class) || !"operations".equals(contSub.rawArgument())) continue;
                    OperationsCreateLeafStatements.applyTo(moduleCtx, contSub);
                    return;
                }
            }
        }
    }

    public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
    }
}

