/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.impl;

import java.util.Objects;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLiteralExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;
import org.opendaylight.yangtools.yang.xpath.api.YangQNameExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathExpression;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathMathMode;
import org.opendaylight.yangtools.yang.xpath.impl.InstanceIdentifierParser;
import org.opendaylight.yangtools.yang.xpath.impl.Utils;

abstract class AntlrYangXPathExpression
implements YangXPathExpression {
    private final YangXPathMathMode mathMode;
    private final YangVersion yangVersion;
    private final YangExpr rootExpr;
    private final String origStr;

    AntlrYangXPathExpression(YangXPathMathMode mathMode, YangVersion yangVersion, YangExpr rootExpr, String origStr) {
        this.mathMode = Objects.requireNonNull(mathMode);
        this.yangVersion = Objects.requireNonNull(yangVersion);
        this.rootExpr = Objects.requireNonNull(rootExpr);
        this.origStr = Objects.requireNonNull(origStr);
    }

    public final YangXPathMathMode getMathMode() {
        return this.mathMode;
    }

    public final YangVersion getYangVersion() {
        return this.yangVersion;
    }

    public final YangExpr getRootExpr() {
        return this.rootExpr;
    }

    public final YangLocationPath.Absolute interpretAsInstanceIdentifier(YangLiteralExpr expr) throws XPathExpressionException {
        return this.createInstanceIdentifierParser().interpretAsInstanceIdentifier(expr);
    }

    public final String toString() {
        return this.origStr;
    }

    abstract InstanceIdentifierParser createInstanceIdentifierParser() throws XPathExpressionException;

    static final class Unqualified
    extends Qualified
    implements YangXPathExpression.UnqualifiedBound {
        private final QNameModule defaultNamespace;

        Unqualified(YangXPathMathMode mathMode, YangVersion yangVersion, YangExpr rootExpr, String origStr, @Nullable YangNamespaceContext namespaceContext, QNameModule defaultNamespace) {
            super(mathMode, yangVersion, rootExpr, origStr, namespaceContext);
            this.defaultNamespace = Objects.requireNonNull(defaultNamespace);
        }

        public YangQNameExpr.Resolved interpretAsQName(YangLiteralExpr expr) throws XPathExpressionException {
            return Utils.interpretAsQName(this.namespaceContext(), this.defaultNamespace, expr);
        }
    }

    static class Qualified
    extends AntlrYangXPathExpression
    implements YangXPathExpression.QualifiedBound {
        private final @Nullable YangNamespaceContext namespaceContext;

        Qualified(YangXPathMathMode mathMode, YangVersion yangVersion, YangExpr rootExpr, String origStr, @Nullable YangNamespaceContext namespaceContext) {
            super(mathMode, yangVersion, rootExpr, origStr);
            this.namespaceContext = namespaceContext;
        }

        final YangNamespaceContext namespaceContext() throws XPathExpressionException {
            YangNamespaceContext local = this.namespaceContext;
            if (local == null) {
                throw new XPathExpressionException("Expression does not have a legal literal member");
            }
            return local;
        }

        public YangQNameExpr interpretAsQName(YangLiteralExpr expr) throws XPathExpressionException {
            return Utils.interpretAsQName(this.namespaceContext(), expr);
        }

        @Override
        final InstanceIdentifierParser createInstanceIdentifierParser() throws XPathExpressionException {
            return new InstanceIdentifierParser.Qualified(this.getMathMode(), this.namespaceContext());
        }
    }

    static final class Base
    extends AntlrYangXPathExpression {
        Base(YangXPathMathMode mathMode, YangVersion yangVersion, YangExpr rootExpr, String origStr) {
            super(mathMode, yangVersion, rootExpr, origStr);
        }

        public YangQNameExpr interpretAsQName(YangLiteralExpr expr) throws XPathExpressionException {
            return Utils.interpretAsQName(expr);
        }

        @Override
        InstanceIdentifierParser createInstanceIdentifierParser() {
            return new InstanceIdentifierParser.Base(this.getMathMode());
        }
    }
}

