/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.ir.IRStatement;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceTransformer;
import org.opendaylight.yangtools.yang.model.spi.source.SourceInfo;
import org.opendaylight.yangtools.yang.model.spi.source.YangIRSource;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.rfc7950.antlr.IRSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangIRSourceInfoExtractor;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangStatementStreamSource;

@Beta
public final class TextToIRTransformer
extends SchemaSourceTransformer<YangTextSource, YangIRSource> {
    private TextToIRTransformer(SchemaRepository provider, SchemaSourceRegistry consumer) {
        super(provider, YangTextSource.class, consumer, YangIRSource.class, input -> Futures.immediateFuture((Object)TextToIRTransformer.transformText(input)));
    }

    public static @NonNull TextToIRTransformer create(SchemaRepository provider, SchemaSourceRegistry consumer) {
        return new TextToIRTransformer(provider, consumer);
    }

    public static @NonNull YangIRSource transformText(YangTextSource text) throws YangSyntaxErrorException, IOException {
        IRStatement rootStatement = IRSupport.createStatement(YangStatementStreamSource.parseYangSource(text));
        SourceInfo info = YangIRSourceInfoExtractor.forIR(rootStatement, text.sourceId());
        return new YangIRSource(info.sourceId(), rootStatement, text.symbolicName());
    }
}

