/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.ir.IRArgument;
import org.opendaylight.yangtools.yang.ir.IRKeyword;
import org.opendaylight.yangtools.yang.ir.IRStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDeclaration;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceReference;
import org.opendaylight.yangtools.yang.model.spi.meta.StatementDeclarations;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ArgumentContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixResolver;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;

class StatementContextVisitor {
    private final QNameToStatementDefinition stmtDef;
    private final ArgumentContextUtils utils;
    private final PrefixResolver prefixes;
    private final StatementWriter writer;
    private final String sourceName;

    StatementContextVisitor(String sourceName, StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixResolver prefixes, YangVersion yangVersion) {
        this.writer = Objects.requireNonNull(writer);
        this.stmtDef = Objects.requireNonNull(stmtDef);
        this.utils = ArgumentContextUtils.forVersion(yangVersion);
        this.sourceName = sourceName;
        this.prefixes = prefixes;
    }

    void visit(IRStatement stmt) {
        this.processStatement(0, stmt);
    }

    QName getValidStatementDefinition(IRKeyword keyword, StatementSourceReference ref) {
        if (keyword instanceof IRKeyword.Qualified) {
            return this.getValidStatementDefinition((IRKeyword.Qualified)keyword, ref);
        }
        StatementDefinition def = this.stmtDef.get(QName.unsafeOf((QNameModule)YangConstants.RFC6020_YIN_MODULE, (String)keyword.identifier()));
        return def != null ? def.getStatementName() : null;
    }

    private QName getValidStatementDefinition(IRKeyword.Qualified keyword, StatementSourceReference ref) {
        if (this.prefixes == null) {
            return null;
        }
        QNameModule qNameModule = this.prefixes.resolvePrefix(keyword.prefix());
        if (qNameModule == null) {
            return null;
        }
        StatementDefinition foundStmtDef = this.resolveStatement(qNameModule, keyword.identifier());
        return foundStmtDef != null ? foundStmtDef.getStatementName() : null;
    }

    StatementDefinition resolveStatement(QNameModule module, String localName) {
        return this.stmtDef.get(QName.unsafeOf((QNameModule)module, (String)localName));
    }

    private boolean processStatement(int myOffset, IRStatement stmt) {
        Optional optResumed = this.writer.resumeStatement(myOffset);
        if (optResumed.isPresent()) {
            StatementWriter.ResumedStatement resumed = (StatementWriter.ResumedStatement)optResumed.orElseThrow();
            return resumed.isFullyDefined() || this.doProcessStatement(stmt, resumed.getSourceReference());
        }
        return this.processNewStatement(myOffset, stmt);
    }

    private boolean processNewStatement(int myOffset, IRStatement stmt) {
        StatementDeclaration.InText ref = StatementDeclarations.inText((String)this.sourceName, (int)stmt.startLine(), (int)(stmt.startColumn() + 1));
        QName def = this.getValidStatementDefinition(stmt.keyword(), (StatementSourceReference)ref);
        if (def == null) {
            return false;
        }
        IRArgument argumentCtx = stmt.argument();
        String argument = argumentCtx == null ? null : this.utils.stringFromStringContext(argumentCtx, (StatementSourceReference)ref);
        this.writer.startStatement(myOffset, def, argument, (StatementSourceReference)ref);
        return this.doProcessStatement(stmt, (StatementSourceReference)ref);
    }

    private boolean doProcessStatement(IRStatement stmt, StatementSourceReference ref) {
        int childOffset = 0;
        boolean fullyDefined = true;
        for (IRStatement substatement : stmt.statements()) {
            if (this.processStatement(childOffset++, substatement)) continue;
            fullyDefined = false;
        }
        this.writer.storeStatement(childOffset, fullyDefined);
        this.writer.endStatement(ref);
        return fullyDefined;
    }
}

