/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import java.util.Objects;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DataStringCodec;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractJSONCodec<T>
implements JSONCodec<T> {
    private final DataStringCodec<T> codec;

    AbstractJSONCodec(DataStringCodec<T> codec) {
        this.codec = Objects.requireNonNull(codec);
    }

    public final Class<T> getDataType() {
        return this.codec.getInputClass();
    }

    public final T parseValue(Object ctx, String str) {
        return (T)this.codec.deserialize((Object)str);
    }

    final String serialize(T input) {
        return (String)this.codec.serialize(input);
    }
}

