/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.BiMapYangNamespaceContext;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;

@Beta
public final class ModuleNameNamespaceContext
implements YangNamespaceContext {
    private static final long serialVersionUID = 2L;
    private final @NonNull EffectiveModelContext modelContext;

    public ModuleNameNamespaceContext(EffectiveModelContext modelContext) {
        this.modelContext = Objects.requireNonNull(modelContext);
    }

    public BiMapYangNamespaceContext toBiMap() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (ModuleEffectiveStatement module : this.modelContext.getModuleStatements().values()) {
            String name = ((UnresolvedQName.Unqualified)module.argument()).getLocalName();
            builder.put((Object)name, (Object)((QNameModule)this.findNamespaceForPrefix(name).orElseThrow()));
        }
        return new BiMapYangNamespaceContext((BiMap)builder.build());
    }

    public QNameModule namespaceForPrefix(String prefix) {
        Iterator modules = this.modelContext.findModuleStatements(prefix).iterator();
        return modules.hasNext() ? ((ModuleEffectiveStatement)modules.next()).localQNameModule() : null;
    }

    public String prefixForNamespace(QNameModule namespace) {
        return this.modelContext.findModuleStatement(namespace).map(module -> ((UnresolvedQName.Unqualified)module.argument()).getLocalName()).orElse(null);
    }

    private Object writeReplace() {
        return this.toBiMap();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ModuleNameNamespaceContext.throwNSE();
    }

    private void readObjectNoData() throws ObjectStreamException {
        ModuleNameNamespaceContext.throwNSE();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ModuleNameNamespaceContext.throwNSE();
    }

    private static void throwNSE() throws NotSerializableException {
        throw new NotSerializableException(ModuleNameNamespaceContext.class.getName());
    }
}

