/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.source;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NonNullByDefault
public interface SourceDependency
extends Serializable {
    public UnresolvedQName.Unqualified name();

    public @Nullable Revision revision();

    default public boolean isSatisfiedBy(SourceIdentifier sourceId) {
        Revision revision;
        return this.name().equals((Object)sourceId.name()) && ((revision = this.revision()) == null || revision.equals((Object)sourceId.revision()));
    }

    public record Include(UnresolvedQName.Unqualified name, @Nullable Revision revision) implements SourceDependency
    {
        private static final long serialVersionUID = 0L;

        public Include(UnresolvedQName.Unqualified name, @Nullable Revision revision) {
            Objects.requireNonNull(name);
        }

        public Include(UnresolvedQName.Unqualified name) {
            this(name, null);
        }
    }

    public record Import(UnresolvedQName.Unqualified name, UnresolvedQName.Unqualified prefix, @Nullable Revision revision) implements SourceDependency
    {
        private static final long serialVersionUID = 0L;

        public Import(UnresolvedQName.Unqualified name, UnresolvedQName.Unqualified prefix, @Nullable Revision revision) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(prefix);
        }

        public Import(UnresolvedQName.Unqualified name, UnresolvedQName.Unqualified prefix) {
            this(name, prefix, null);
        }
    }

    public record BelongsTo(UnresolvedQName.Unqualified name, UnresolvedQName.Unqualified prefix) implements SourceDependency
    {
        private static final long serialVersionUID = 0L;

        public BelongsTo {
            Objects.requireNonNull(name);
            Objects.requireNonNull(prefix);
        }

        @Override
        public @Nullable Revision revision() {
            return null;
        }
    }
}

