/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.util.ConstantArrayCollection;
import org.opendaylight.yangtools.util.MutableOffsetMap;
import org.opendaylight.yangtools.util.OIOMv1;
import org.opendaylight.yangtools.util.OffsetMapCache;
import org.opendaylight.yangtools.util.SharedSingletonMap;
import org.opendaylight.yangtools.util.UIOMv1;
import org.opendaylight.yangtools.util.UnmodifiableMapPhase;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ImmutableOffsetMap<K, V>
implements UnmodifiableMapPhase<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final @NonNull ImmutableMap<K, Integer> offsets;
    private final @NonNull V[] objects;
    private transient int hashCode;

    private ImmutableOffsetMap(ImmutableMap<K, Integer> offsets, V[] objects) {
        this.offsets = Objects.requireNonNull(offsets);
        this.objects = Objects.requireNonNull(objects);
        Preconditions.checkArgument((offsets.size() == objects.length ? 1 : 0) != 0);
    }

    @Override
    public abstract @NonNull MutableOffsetMap<K, V> toModifiableMap();

    public static <K, V> @NonNull Map<K, V> orderedCopyOf(@NonNull Map<K, V> map) {
        Map<K, V> common = ImmutableOffsetMap.commonCopy(map);
        if (common != null) {
            return common;
        }
        int size = map.size();
        if (size == 1) {
            Map.Entry<K, V> e = map.entrySet().iterator().next();
            return SharedSingletonMap.orderedOf(e.getKey(), e.getValue());
        }
        ImmutableMap<K, Integer> offsets = OffsetMapCache.orderedOffsets(map.keySet());
        return new Ordered<K, V>(offsets, ImmutableOffsetMap.createArray(offsets, map));
    }

    public static <K, V> @NonNull Map<K, V> unorderedCopyOf(@NonNull Map<K, V> map) {
        Map<K, V> common = ImmutableOffsetMap.commonCopy(map);
        if (common != null) {
            return common;
        }
        if (map.size() == 1) {
            Map.Entry<K, V> e = map.entrySet().iterator().next();
            return SharedSingletonMap.unorderedOf(e.getKey(), e.getValue());
        }
        ImmutableMap<K, Integer> offsets = OffsetMapCache.unorderedOffsets(map.keySet());
        return new Unordered<K, V>(offsets, ImmutableOffsetMap.createArray(offsets, map));
    }

    private static <K, V> V[] createArray(ImmutableMap<K, Integer> offsets, Map<K, V> map) {
        Object[] array = new Object[offsets.size()];
        for (Map.Entry<K, V> e : map.entrySet()) {
            array[((Integer)Verify.verifyNotNull((Object)((Integer)offsets.get(e.getKey())))).intValue()] = e.getValue();
        }
        return array;
    }

    private static <K, V> @Nullable Map<K, V> commonCopy(@NonNull Map<K, V> map) {
        if (map instanceof ImmutableOffsetMap || map instanceof SharedSingletonMap) {
            return map;
        }
        if (map instanceof MutableOffsetMap) {
            MutableOffsetMap mop = (MutableOffsetMap)map;
            return mop.toUnmodifiableMap();
        }
        if (map.isEmpty()) {
            return ImmutableMap.of();
        }
        return null;
    }

    @Override
    public final int size() {
        return this.offsets.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.offsets.isEmpty();
    }

    @Override
    public final int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int result = 0;
        for (Map.Entry e : this.offsets.entrySet()) {
            result += e.getKey().hashCode() ^ this.objects[(Integer)e.getValue()].hashCode();
        }
        this.hashCode = result;
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (obj instanceof ImmutableOffsetMap) {
            ImmutableOffsetMap om = (ImmutableOffsetMap)obj;
            if (this.offsets.equals(om.offsets)) {
                return Arrays.deepEquals(this.objects, om.objects);
            }
        } else if (obj instanceof MutableOffsetMap) {
            return obj.equals(this);
        }
        if (this.size() != other.size() || !this.keySet().equals(other.keySet())) {
            return false;
        }
        try {
            for (Map.Entry e : this.offsets.entrySet()) {
                if (this.objects[(Integer)e.getValue()].equals(other.get(e.getKey()))) continue;
                return false;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.offsets.containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        for (V o : this.objects) {
            if (!value.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final V get(Object key) {
        Integer offset = (Integer)this.offsets.get(key);
        return offset == null ? null : (V)this.objects[offset];
    }

    @Override
    public final V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Set<K> keySet() {
        return this.offsets.keySet();
    }

    @Override
    public final @NonNull Collection<V> values() {
        return new ConstantArrayCollection<V>(this.objects);
    }

    @Override
    public final @NonNull Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("{");
        UnmodifiableIterator it = this.offsets.keySet().iterator();
        int offset = 0;
        while (it.hasNext()) {
            sb.append(it.next()).append('=').append(this.objects[offset++]);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append('}').toString();
    }

    final @NonNull ImmutableMap<K, Integer> offsets() {
        return this.offsets;
    }

    final @NonNull V[] objects() {
        return this.objects;
    }

    abstract Object writeReplace();

    static final class Ordered<K, V>
    extends ImmutableOffsetMap<K, V> {
        private static final long serialVersionUID = 1L;

        Ordered(ImmutableMap<K, Integer> offsets, V[] objects) {
            super(offsets, objects);
        }

        @Override
        public MutableOffsetMap<K, V> toModifiableMap() {
            return MutableOffsetMap.orderedCopyOf(this);
        }

        @Override
        Object writeReplace() {
            return new OIOMv1(this);
        }
    }

    static final class Unordered<K, V>
    extends ImmutableOffsetMap<K, V> {
        private static final long serialVersionUID = 1L;

        Unordered(ImmutableMap<K, Integer> offsets, V[] objects) {
            super(offsets, objects);
        }

        @Override
        public MutableOffsetMap<K, V> toModifiableMap() {
            return MutableOffsetMap.unorderedCopyOf(this);
        }

        @Override
        Object writeReplace() {
            return new UIOMv1(this);
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public @NonNull Iterator<Map.Entry<K, V>> iterator() {
            UnmodifiableIterator it = ImmutableOffsetMap.this.offsets.entrySet().iterator();
            return new UnmodifiableIterator<Map.Entry<K, V>>((Iterator)it){
                final /* synthetic */ Iterator val$it;
                {
                    this.val$it = iterator;
                }

                public boolean hasNext() {
                    return this.val$it.hasNext();
                }

                public Map.Entry<K, V> next() {
                    Map.Entry e = (Map.Entry)this.val$it.next();
                    return new AbstractMap.SimpleImmutableEntry(e.getKey(), ImmutableOffsetMap.this.objects[(Integer)e.getValue()]);
                }
            };
        }

        @Override
        public int size() {
            return ImmutableOffsetMap.this.offsets.size();
        }
    }
}

