/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public enum DeviateKind {
    NOT_SUPPORTED("not-supported"),
    ADD("add"),
    REPLACE("replace"),
    DELETE("delete");

    private final String argument;

    private DeviateKind(String argument) {
        this.argument = Objects.requireNonNull(argument);
    }

    public String argument() {
        return this.argument;
    }

    public static @Nullable DeviateKind forArgument(String argument) {
        return switch (argument) {
            case "not-supported" -> NOT_SUPPORTED;
            case "add" -> ADD;
            case "replace" -> REPLACE;
            case "delete" -> DELETE;
            default -> null;
        };
    }

    public static DeviateKind ofArgument(String argument) {
        DeviateKind ret = DeviateKind.forArgument(argument);
        if (ret == null) {
            throw new IllegalArgumentException("\"" + argument + "\" is not a valid deviate statement argument");
        }
        return ret;
    }
}

