/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8040.parser;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.TypeDefinitions;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class OperationsCreateLeafStatements
implements ModelActionBuilder.InferenceAction {
    private final List<ModelActionBuilder.Prerequisite<? extends StmtContext<?, ?, ?>>> prereqs;
    private final StmtContext.Mutable<?, ?, ?> operations;

    private OperationsCreateLeafStatements(StmtContext.Mutable<?, ?, ?> operations, List<ModelActionBuilder.Prerequisite<? extends StmtContext<?, ?, ?>>> prereqs) {
        this.operations = Objects.requireNonNull(operations);
        this.prereqs = Objects.requireNonNull(prereqs);
    }

    static void applyTo(StmtContext<?, ?, ?> ietfRestconfModule, StmtContext.Mutable<?, ?, ?> operations) {
        ModelActionBuilder action = operations.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        action.mutatesEffectiveCtx(operations);
        ArrayList prereqs = new ArrayList();
        for (StmtContext module : ietfRestconfModule.namespace(ParserNamespaces.MODULE).values()) {
            if (ietfRestconfModule.equals((Object)module)) continue;
            prereqs.add(action.requiresCtx(module, ModelProcessingPhase.EFFECTIVE_MODEL));
        }
        action.apply((ModelActionBuilder.InferenceAction)new OperationsCreateLeafStatements(operations, prereqs));
    }

    public void apply(ModelActionBuilder.InferenceContext ctx) {
        List qnames = this.prereqs.stream().flatMap(prereq -> ((StmtContext)prereq.resolve(ctx)).declaredSubstatements().stream()).filter(stmt -> stmt.producesDeclared(RpcStatement.class) && stmt.isSupportedToBuildEffective() && stmt.isSupportedByFeatures()).map(stmt -> (QName)stmt.argument()).sorted(Comparator.naturalOrder()).distinct().collect(Collectors.toUnmodifiableList());
        if (!qnames.isEmpty()) {
            StatementSupport leafSupport = this.getSupport((StatementDefinition)YangStmtMapping.LEAF, LeafEffectiveStatement.class);
            StatementSupport typeSupport = this.getSupport((StatementDefinition)YangStmtMapping.TYPE, TypeEffectiveStatement.class);
            for (QName qname : qnames) {
                StmtContext.Mutable leaf = this.operations.createUndeclaredSubstatement(leafSupport, (Object)qname);
                leaf.addEffectiveSubstatement(leaf.createUndeclaredSubstatement(typeSupport, (Object)TypeDefinitions.EMPTY));
                this.operations.addEffectiveSubstatement(leaf);
            }
        }
    }

    public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
    }

    private <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> StatementSupport<X, Y, Z> getSupport(StatementDefinition def, Class<Z> effectiveClass) {
        StatementSupport tmp = (StatementSupport)Verify.verifyNotNull((Object)((StatementSupport)this.operations.namespaceItem(StatementSupport.NAMESPACE, (Object)def.getStatementName())));
        Class repr = tmp.definition().getEffectiveRepresentationClass();
        Verify.verify((boolean)effectiveClass.equals(repr), (String)"Unexpected support %s representation %s", (Object)tmp, (Object)repr);
        StatementSupport ret = tmp;
        return ret;
    }
}

