/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtxCompat;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ModifierImpl
implements ModelActionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ModifierImpl.class);
    private final Set<AbstractPrerequisite<?>> unsatisfied = new HashSet(1);
    private final Set<AbstractPrerequisite<?>> mutations = new HashSet(1);
    private final ModelActionBuilder.InferenceContext ctx = new ModelActionBuilder.InferenceContext(){};
    private List<Runnable> bootstraps;
    private ModelActionBuilder.InferenceAction action;
    private boolean actionApplied;

    ModifierImpl() {
    }

    private <D> AbstractPrerequisite<D> addReq(AbstractPrerequisite<D> prereq) {
        LOG.trace("Modifier {} adding prerequisite {}", (Object)this, prereq);
        this.unsatisfied.add(prereq);
        return prereq;
    }

    private <T> @NonNull AbstractPrerequisite<T> addMutation(@NonNull AbstractPrerequisite<T> mutation) {
        LOG.trace("Modifier {} adding mutation {}", (Object)this, mutation);
        this.mutations.add(mutation);
        return mutation;
    }

    private void checkNotRegistered() {
        Preconditions.checkState((this.action == null ? 1 : 0) != 0, (Object)"Action was already registered.");
    }

    private boolean removeSatisfied() {
        Iterator<AbstractPrerequisite<?>> it = this.unsatisfied.iterator();
        while (it.hasNext()) {
            AbstractPrerequisite<?> prereq = it.next();
            if (!prereq.isDone()) continue;
            LOG.trace("Modifier {} prerequisite {} satisfied", (Object)this, prereq);
            it.remove();
        }
        return this.unsatisfied.isEmpty();
    }

    boolean isApplied() {
        return this.actionApplied;
    }

    void failModifier() {
        this.removeSatisfied();
        ((ModelActionBuilder.InferenceAction)Verify.verifyNotNull((Object)this.action)).prerequisiteFailed(this.unsatisfied);
        this.action = null;
    }

    private <K, C extends StmtContext<?, ?, ?>> @NonNull AbstractPrerequisite<C> requiresCtxImpl(StmtContext<?, ?, ?> context, ParserNamespace<K, C> namespace, K key, ModelProcessingPhase phase) {
        this.checkNotRegistered();
        AddedToNamespace addedToNs = new AddedToNamespace(this, phase);
        this.addReq(addedToNs);
        ModifierImpl.contextImpl(context).onNamespaceItemAddedAction(namespace, key, addedToNs);
        return addedToNs;
    }

    private <K, C extends StmtContext<?, ?, ?>> @NonNull AbstractPrerequisite<C> requiresCtxImpl(StmtContext<?, ?, ?> context, ParserNamespace<K, C> namespace, NamespaceKeyCriterion<K> criterion, ModelProcessingPhase phase) {
        this.checkNotRegistered();
        AddedToNamespace addedToNs = new AddedToNamespace(this, phase);
        this.addReq(addedToNs);
        ModifierImpl.contextImpl(context).onNamespaceItemAddedAction(namespace, phase, criterion, addedToNs);
        return addedToNs;
    }

    private <C extends StmtContext<?, ?, ?>> @NonNull AbstractPrerequisite<C> requiresCtxImpl(C context, ModelProcessingPhase phase) {
        this.checkNotRegistered();
        PhaseFinished phaseFin = new PhaseFinished(this);
        this.addReq(phaseFin);
        this.addBootstrap(() -> ModifierImpl.contextImpl(context).addPhaseCompletedListener(phase, phaseFin));
        return phaseFin;
    }

    private <K, C extends StmtContext.Mutable<?, ?, ?>> AbstractPrerequisite<C> mutatesCtxImpl(StmtContext<?, ?, ?> context, ParserNamespace<K, ? extends StmtContext<?, ?, ?>> namespace, K key, ModelProcessingPhase phase) {
        this.checkNotRegistered();
        PhaseModificationInNamespace mod = new PhaseModificationInNamespace(this, ModelProcessingPhase.EFFECTIVE_MODEL);
        this.addReq(mod);
        this.addMutation(mod);
        ModifierImpl.contextImpl(context).onNamespaceItemAddedAction(namespace, key, mod);
        return mod;
    }

    private static StatementContextBase<?, ?, ?> contextImpl(Object value) {
        if (value instanceof StatementContextBase) {
            StatementContextBase impl = (StatementContextBase)value;
            return impl;
        }
        throw new IllegalArgumentException("Supplied context " + value + " is not provided by this reactor.");
    }

    boolean tryApply() {
        Preconditions.checkState((this.action != null ? 1 : 0) != 0, (Object)"Action was not defined yet.");
        if (this.removeSatisfied()) {
            if (!this.actionApplied) {
                this.action.apply(this.ctx);
                this.actionApplied = true;
            }
            return true;
        }
        return false;
    }

    public <C extends StmtContext.Mutable<?, ?, ?>, T extends C> ModelActionBuilder.Prerequisite<C> mutatesCtx(T context, ModelProcessingPhase phase) {
        return this.addMutation(new PhaseMutation(this, ModifierImpl.contextImpl(context), phase));
    }

    public <A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> AbstractPrerequisite<StmtContext<A, D, E>> requiresCtx(StmtContext<A, D, E> context, ModelProcessingPhase phase) {
        return this.requiresCtxImpl(context, phase);
    }

    public <K, C extends StmtContext<?, ?, ?>> ModelActionBuilder.Prerequisite<C> requiresCtx(StmtContext<?, ?, ?> context, ParserNamespace<K, C> namespace, K key, ModelProcessingPhase phase) {
        return this.requiresCtxImpl(context, namespace, key, phase);
    }

    public <K, C extends StmtContext<?, ?, ?>> ModelActionBuilder.Prerequisite<C> requiresCtx(StmtContext<?, ?, ?> context, ParserNamespace<K, C> namespace, NamespaceKeyCriterion<K> criterion, ModelProcessingPhase phase) {
        return this.requiresCtxImpl(context, namespace, criterion, phase);
    }

    public <K, C extends StmtContext<?, ?, ?>> ModelActionBuilder.Prerequisite<C> requiresEffectiveCtxPath(StmtContext<?, ?, ?> context, ParserNamespace<K, C> namespace, Iterable<K> keys) {
        this.checkNotRegistered();
        PhaseRequirementInNamespacePath ret = new PhaseRequirementInNamespacePath(this, keys);
        this.addReq(ret);
        this.addBootstrap(() -> ret.hookOnto(context, namespace));
        return ret;
    }

    public <D extends DeclaredStatement<?>> ModelActionBuilder.Prerequisite<D> requiresDeclared(StmtContext<?, ? extends D, ?> context) {
        return this.requiresCtxImpl(context, ModelProcessingPhase.FULL_DECLARATION).transform(BoundStmtCtxCompat::declared);
    }

    @Deprecated
    public <K, D extends DeclaredStatement<?>> ModelActionBuilder.Prerequisite<D> requiresDeclared(StmtContext<?, ?, ?> context, ParserNamespace<K, StmtContext<?, ? extends D, ?>> namespace, K key) {
        return this.requiresCtxImpl(context, namespace, key, ModelProcessingPhase.FULL_DECLARATION).transform(BoundStmtCtxCompat::declared);
    }

    @Deprecated
    public <K, C extends StmtContext<?, ?, ?>> AbstractPrerequisite<C> requiresDeclaredCtx(StmtContext<?, ?, ?> context, ParserNamespace<K, C> namespace, K key) {
        return this.requiresCtxImpl(context, namespace, key, ModelProcessingPhase.FULL_DECLARATION);
    }

    @Deprecated
    public <E extends EffectiveStatement<?, ?>> ModelActionBuilder.Prerequisite<E> requiresEffective(StmtContext<?, ?, ? extends E> stmt) {
        return this.requiresCtxImpl(stmt, ModelProcessingPhase.EFFECTIVE_MODEL).transform(StmtContext::buildEffective);
    }

    @Deprecated
    public <K, E extends EffectiveStatement<?, ?>> ModelActionBuilder.Prerequisite<E> requiresEffective(StmtContext<?, ?, ?> context, ParserNamespace<K, StmtContext<?, ?, ? extends E>> namespace, K key) {
        return this.requiresCtxImpl(context, namespace, key, ModelProcessingPhase.EFFECTIVE_MODEL).transform(StmtContext::buildEffective);
    }

    @Deprecated
    public <K, C extends StmtContext<?, ?, ?>> AbstractPrerequisite<C> requiresEffectiveCtx(StmtContext<?, ?, ?> context, ParserNamespace<K, C> namespace, K key) {
        return this.requiresCtxImpl((StmtContext<?, ?, ?>)ModifierImpl.contextImpl(context), namespace, key, ModelProcessingPhase.EFFECTIVE_MODEL);
    }

    @Deprecated
    public ModelActionBuilder.Prerequisite<StmtContext.Mutable<?, ?, ?>> mutatesNs(StmtContext.Mutable<?, ?, ?> context, ParserNamespace<?, ?> namespace) {
        return this.addMutation(new NamespaceMutation(this, ModifierImpl.contextImpl(context), namespace));
    }

    public <K, E extends EffectiveStatement<?, ?>> AbstractPrerequisite<StmtContext.Mutable<?, ?, E>> mutatesEffectiveCtx(StmtContext<?, ?, ?> context, ParserNamespace<K, ? extends StmtContext<?, ?, ?>> namespace, K key) {
        return this.mutatesCtxImpl(context, namespace, key, ModelProcessingPhase.EFFECTIVE_MODEL);
    }

    public <K, E extends EffectiveStatement<?, ?>> AbstractPrerequisite<StmtContext.Mutable<?, ?, E>> mutatesEffectiveCtxPath(StmtContext<?, ?, ?> context, ParserNamespace<K, ? extends StmtContext<?, ?, ?>> namespace, Iterable<K> keys) {
        this.checkNotRegistered();
        PhaseModificationInNamespacePath ret = new PhaseModificationInNamespacePath(this, keys);
        this.addReq(ret);
        this.addMutation(ret);
        this.addBootstrap(() -> ret.hookOnto(context, namespace));
        return ret;
    }

    public void apply(ModelActionBuilder.InferenceAction action) {
        Preconditions.checkState((this.action == null ? 1 : 0) != 0, (String)"Action already defined to %s", (Object)this.action);
        this.action = Objects.requireNonNull(action);
        if (this.bootstraps != null) {
            this.bootstraps.forEach(Runnable::run);
            this.bootstraps = null;
        }
    }

    private void addBootstrap(Runnable bootstrap) {
        if (this.bootstraps == null) {
            this.bootstraps = new ArrayList<Runnable>(1);
        }
        this.bootstraps.add(bootstrap);
    }

    private static abstract class AbstractPrerequisite<T>
    implements ModelActionBuilder.Prerequisite<T> {
        final @NonNull ModifierImpl modifier;
        private boolean done = false;
        private T value;

        AbstractPrerequisite(ModifierImpl modifier) {
            this.modifier = Objects.requireNonNull(modifier);
        }

        public final T resolve(ModelActionBuilder.InferenceContext ctx) {
            Preconditions.checkState((boolean)this.done);
            Preconditions.checkArgument((ctx == this.modifier.ctx ? 1 : 0) != 0);
            return (T)Verify.verifyNotNull(this.value, (String)"Attempted to access unavailable prerequisite %s", (Object[])new Object[]{this});
        }

        final boolean isDone() {
            return this.done;
        }

        final boolean resolvePrereq(T value) {
            this.value = value;
            this.done = true;
            return this.modifier.isApplied();
        }

        final <O> // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ModelActionBuilder.Prerequisite<O> transform(Function<? super T, O> transformation) {
            return context -> transformation.apply((T)this.resolve(context));
        }

        public final String toString() {
            return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
        }

        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return toStringHelper.add("value", this.value);
        }
    }

    private static final class AddedToNamespace<C extends StmtContext<?, ?, ?>>
    extends AbstractPrerequisite<C>
    implements StatementContextBase.OnNamespaceItemAdded,
    StatementContextBase.OnPhaseFinished {
        private final ModelProcessingPhase phase;

        AddedToNamespace(ModifierImpl modifier, ModelProcessingPhase phase) {
            super(modifier);
            this.phase = Objects.requireNonNull(phase);
        }

        @Override
        public void namespaceItemAdded(StatementContextBase<?, ?, ?> context, ParserNamespace<?, ?> namespace, Object key, Object value) {
            ModifierImpl.contextImpl(value).addPhaseCompletedListener(this.phase, this);
        }

        @Override
        public boolean phaseFinished(StatementContextBase<?, ?, ?> context, ModelProcessingPhase finishedPhase) {
            return this.resolvePrereq(context) || this.modifier.tryApply();
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return super.addToStringAttributes(toStringHelper).add("phase", (Object)this.phase);
        }
    }

    private static final class PhaseFinished<C extends StmtContext<?, ?, ?>>
    extends AbstractPrerequisite<C>
    implements StatementContextBase.OnPhaseFinished {
        PhaseFinished(ModifierImpl modifier) {
            super(modifier);
        }

        @Override
        public boolean phaseFinished(StatementContextBase<?, ?, ?> context, ModelProcessingPhase finishedPhase) {
            return this.resolvePrereq(context) || this.modifier.tryApply();
        }
    }

    private static final class PhaseModificationInNamespace<C extends StmtContext.Mutable<?, ?, ?>>
    extends AbstractPrerequisite<C>
    implements StatementContextBase.OnNamespaceItemAdded,
    StatementContextBase.ContextMutation {
        private final ModelProcessingPhase modPhase;

        PhaseModificationInNamespace(ModifierImpl modifier, ModelProcessingPhase phase) {
            super(modifier);
            if (phase == null) {
                throw new IllegalArgumentException("Model processing phase must not be null");
            }
            this.modPhase = phase;
        }

        @Override
        public void namespaceItemAdded(StatementContextBase<?, ?, ?> context, ParserNamespace<?, ?> namespace, Object key, Object value) {
            StatementContextBase<?, ?, ?> targetCtx = ModifierImpl.contextImpl(value);
            targetCtx.addMutation(this.modPhase, this);
            this.resolvePrereq(targetCtx);
        }

        @Override
        public boolean isFinished() {
            return this.modifier.isApplied();
        }
    }

    private static final class PhaseMutation<C>
    extends AbstractPrerequisite<C>
    implements StatementContextBase.ContextMutation {
        PhaseMutation(ModifierImpl modifier, StatementContextBase<?, ?, ?> context, ModelProcessingPhase phase) {
            super(modifier);
            context.addMutation(phase, this);
            this.resolvePrereq(context);
        }

        @Override
        public boolean isFinished() {
            return this.modifier.isApplied();
        }
    }

    private static final class PhaseRequirementInNamespacePath<C extends StmtContext<?, ?, ?>, K>
    extends AbstractPathPrerequisite<C, K> {
        PhaseRequirementInNamespacePath(ModifierImpl modifier, Iterable<K> keys) {
            super(modifier, keys);
        }

        @Override
        void nextStep(StatementContextBase<?, ?, ?> current, StatementContextBase<?, ?, ?> next) {
        }
    }

    private static final class NamespaceMutation
    extends AbstractPrerequisite<StmtContext.Mutable<?, ?, ?>> {
        NamespaceMutation(ModifierImpl modifier, StatementContextBase<?, ?, ?> ctx, ParserNamespace<?, ?> namespace) {
            super(modifier);
            this.resolvePrereq(ctx);
        }
    }

    private static final class PhaseModificationInNamespacePath<C extends StmtContext.Mutable<?, ?, ?>, K>
    extends AbstractPathPrerequisite<C, K>
    implements StatementContextBase.ContextMutation {
        PhaseModificationInNamespacePath(ModifierImpl modifier, Iterable<K> keys) {
            super(modifier, keys);
        }

        @Override
        public boolean isFinished() {
            return this.modifier.isApplied();
        }

        @Override
        void nextStep(StatementContextBase<?, ?, ?> current, StatementContextBase<?, ?, ?> next) {
            next.addMutation(ModelProcessingPhase.EFFECTIVE_MODEL, this);
            current.removeMutation(ModelProcessingPhase.EFFECTIVE_MODEL, this);
        }
    }

    private static abstract class AbstractPathPrerequisite<C extends StmtContext<?, ?, ?>, K>
    extends AbstractPrerequisite<C>
    implements StatementContextBase.OnNamespaceItemAdded {
        private final Iterable<K> keys;
        private final Iterator<K> it;

        AbstractPathPrerequisite(ModifierImpl modifier, Iterable<K> keys) {
            super(modifier);
            this.keys = Objects.requireNonNull(keys);
            this.it = keys.iterator();
        }

        @Override
        public final void namespaceItemAdded(StatementContextBase<?, ?, ?> context, ParserNamespace<?, ?> namespace, Object key, Object value) {
            LOG.debug("Action for {} got key {}", this.keys, key);
            ModifierImpl.contextImpl(value).addPhaseCompletedListener(ModelProcessingPhase.FULL_DECLARATION, (target, ignored) -> {
                if (target.isSupportedByFeatures()) {
                    this.nextStep(context, target);
                    if (this.it.hasNext()) {
                        this.hookOnto(target, namespace, this.it.next());
                    } else if (this.resolvePrereq(target)) {
                        this.modifier.tryApply();
                    }
                } else {
                    LOG.debug("Key {} in {} is not supported", key, this.keys);
                    this.resolvePrereq(null);
                    ((ModelActionBuilder.InferenceAction)Verify.verifyNotNull((Object)this.modifier.action)).prerequisiteUnavailable((ModelActionBuilder.Prerequisite)this);
                }
                return true;
            });
        }

        abstract void nextStep(StatementContextBase<?, ?, ?> var1, StatementContextBase<?, ?, ?> var2);

        @Override
        final MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return super.addToStringAttributes(toStringHelper).add("keys", this.keys);
        }

        final void hookOnto(StmtContext<?, ?, ?> context, ParserNamespace<?, ?> namespace) {
            Preconditions.checkArgument((boolean)this.it.hasNext(), (String)"Namespace %s keys may not be empty", namespace);
            this.hookOnto(ModifierImpl.contextImpl(context), namespace, this.it.next());
        }

        private void hookOnto(StatementContextBase<?, ?, ?> context, ParserNamespace<?, ?> namespace, K key) {
            context.onNamespaceItemAddedAction(namespace, Objects.requireNonNull(key), this);
        }
    }
}

