/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangPredicateAware;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class YangFilterExpr
implements YangExpr,
YangPredicateAware {
    private static final long serialVersionUID = 1L;
    private final YangExpr expr;

    private YangFilterExpr(YangExpr expr) {
        this.expr = Objects.requireNonNull(expr);
    }

    public static YangFilterExpr of(YangExpr expr) {
        return new YangFilterExpr(expr);
    }

    public static YangFilterExpr of(YangExpr expr, YangExpr ... predicates) {
        return YangFilterExpr.of(expr, Arrays.asList(predicates));
    }

    public static YangFilterExpr of(YangExpr expr, Collection<YangExpr> predicates) {
        return predicates.isEmpty() ? YangFilterExpr.of(expr) : new WithPredicates(expr, (ImmutableSet<YangExpr>)ImmutableSet.copyOf(predicates));
    }

    public final YangExpr getExpr() {
        return this.expr;
    }

    public final int hashCode() {
        return Objects.hash(this.expr, this.getPredicates());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof YangFilterExpr)) return false;
        YangFilterExpr other = (YangFilterExpr)obj;
        if (!this.expr.equals(other.expr)) return false;
        if (!this.getPredicates().equals(other.getPredicates())) return false;
        return true;
    }

    public final String toString() {
        return "-(" + this.expr + ")";
    }

    private static final class WithPredicates
    extends YangFilterExpr {
        private static final long serialVersionUID = 1L;
        private final ImmutableSet<YangExpr> predicates;

        WithPredicates(YangExpr expr, ImmutableSet<YangExpr> predicates) {
            super(expr);
            this.predicates = Objects.requireNonNull(predicates);
        }

        @Override
        public Set<YangExpr> getPredicates() {
            return this.predicates;
        }
    }
}

