/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.ri.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.ri.type.IdentityrefTypeBuilder;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.AbstractTypeSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.IdentityRefSpecificationImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.RefIdentityRefSpecification;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

final class IdentityRefSpecificationSupport
extends AbstractTypeSupport<TypeStatement.IdentityRefSpecification> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addMandatory((StatementDefinition)YangStmtMapping.BASE).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addMultiple((StatementDefinition)YangStmtMapping.BASE).build();

    private IdentityRefSpecificationSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super(config, validator);
    }

    static @NonNull IdentityRefSpecificationSupport rfc6020Instance(YangParserConfiguration config) {
        return new IdentityRefSpecificationSupport(config, RFC6020_VALIDATOR);
    }

    static @NonNull IdentityRefSpecificationSupport rfc7950Instance(YangParserConfiguration config) {
        return new IdentityRefSpecificationSupport(config, RFC7950_VALIDATOR);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<QName, TypeStatement.IdentityRefSpecification, EffectiveStatement<QName, TypeStatement.IdentityRefSpecification>> stmt) {
        super.onFullDefinitionDeclared(stmt);
        Collection baseStatements = StmtContextUtils.findAllDeclaredSubstatements(stmt, BaseStatement.class);
        for (StmtContext baseStmt : baseStatements) {
            QName baseIdentity = (QName)baseStmt.getArgument();
            StmtContext stmtCtx = (StmtContext)stmt.namespaceItem(ParserNamespaces.IDENTITY, (Object)baseIdentity);
            InferenceException.throwIfNull((Object)stmtCtx, stmt, (String)"Referenced base identity '%s' doesn't exist in given scope (module, imported modules, submodules)", (Object[])new Object[]{baseIdentity.getLocalName()});
        }
    }

    protected TypeStatement.IdentityRefSpecification createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        if (substatements.isEmpty()) {
            throw IdentityRefSpecificationSupport.noBase(ctx);
        }
        return new IdentityRefSpecificationImpl(ctx.getRawArgument(), (QName)ctx.getArgument(), substatements);
    }

    protected TypeStatement.IdentityRefSpecification attachDeclarationReference(TypeStatement.IdentityRefSpecification stmt, DeclarationReference reference) {
        return new RefIdentityRefSpecification(stmt, reference);
    }

    protected EffectiveStatement<QName, TypeStatement.IdentityRefSpecification> createEffective(EffectiveStmtCtx.Current<QName, TypeStatement.IdentityRefSpecification> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        if (substatements.isEmpty()) {
            throw IdentityRefSpecificationSupport.noBase(stmt);
        }
        IdentityrefTypeBuilder builder = BaseTypes.identityrefTypeBuilder((QName)stmt.argumentAsTypeQName());
        for (EffectiveStatement subStmt : substatements) {
            if (!(subStmt instanceof BaseEffectiveStatement)) continue;
            QName identityQName = (QName)((BaseEffectiveStatement)subStmt).argument();
            IdentityEffectiveStatement baseIdentity = (IdentityEffectiveStatement)((StmtContext)Verify.verifyNotNull((Object)((StmtContext)stmt.namespaceItem(ParserNamespaces.IDENTITY, (Object)identityQName)))).buildEffective();
            Verify.verify((boolean)(baseIdentity instanceof IdentitySchemaNode), (String)"Statement %s is not an IdentitySchemaNode", (Object)baseIdentity);
            builder.addIdentity((IdentitySchemaNode)baseIdentity);
        }
        return new TypeEffectiveStatementImpl((TypeStatement.IdentityRefSpecification)stmt.declared(), (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static SourceException noBase(CommonStmtCtx stmt) {
        return new SourceException("At least one base statement has to be present", stmt);
    }
}

