/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.annotations.Beta;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;

@Beta
@NonNullByDefault
public final class PatternExpression
implements Immutable {
    private static final Interner<PatternExpression> INTERNER = Interners.newWeakInterner();
    private final String pattern;
    private final String regex;

    private PatternExpression(String regex, String pattern) {
        this.regex = Objects.requireNonNull(regex);
        this.pattern = Objects.requireNonNull(pattern);
    }

    public static PatternExpression of(String regex, String pattern) {
        return new PatternExpression(regex, pattern);
    }

    public String getJavaPatternString() {
        return this.pattern;
    }

    public String getRegularExpressionString() {
        return this.regex;
    }

    public PatternExpression intern() {
        return (PatternExpression)INTERNER.intern((Object)this);
    }

    public int hashCode() {
        return this.regex.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof PatternExpression)) return false;
        PatternExpression other = (PatternExpression)obj;
        if (!this.regex.equals(other.regex)) return false;
        if (!this.pattern.equals(other.pattern)) return false;
        return true;
    }

    public String toString() {
        return this.regex;
    }
}

