/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import tech.pantheon.triemap.ImmutableIterator;
import tech.pantheon.triemap.TrieMap;

abstract class AbstractKeySet<K>
extends AbstractSet<K> {
    private final TrieMap<K, ?> map;

    AbstractKeySet(TrieMap<K, ?> map) {
        this.map = Objects.requireNonNull(map);
    }

    final TrieMap<K, ?> map() {
        return this.map;
    }

    @Override
    public final boolean add(K e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(Collection<? extends K> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final Spliterator<K> spliterator() {
        return Spliterators.spliterator(this.immutableIterator(), Long.MAX_VALUE, this.spliteratorCharacteristics());
    }

    abstract int spliteratorCharacteristics();

    final Iterator<K> immutableIterator() {
        return new Iterator<K>(){
            private final ImmutableIterator<K, ?> itr;
            {
                this.itr = AbstractKeySet.this.map().immutableIterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public K next() {
                return this.itr.next().getKey();
            }
        };
    }
}

