/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStorage;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceAccess;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SweptNamespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractNamespaceStorage
implements NamespaceStorage {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNamespaceStorage.class);
    private Map<ParserNamespace<?, ?>, Map<?, ?>> namespaces = ImmutableMap.of();

    AbstractNamespaceStorage() {
    }

    abstract <K, V> @NonNull NamespaceAccess<K, V> accessNamespace(ParserNamespace<K, V> var1);

    final void checkLocalNamespaceAllowed(ParserNamespace<?, ?> type) {
    }

    <K, V> void onNamespaceElementAdded(ParserNamespace<K, V> type, K key, V value) {
    }

    final <K, V> Map<K, V> getNamespace(ParserNamespace<K, V> type) {
        return this.accessNamespace(type).allFrom(this);
    }

    final <K, V> Map<K, V> getLocalNamespace(ParserNamespace<K, V> type) {
        Map local = (Map)Verify.verifyNotNull(this.namespaces, (String)"Attempted to access swept namespaces of %s", (Object[])new Object[]{this});
        return (Map)local.get(type);
    }

    final <K, V> void addToNamespace(ParserNamespace<K, V> type, K key, V value) {
        this.accessNamespace(type).valueTo(this, key, value);
    }

    public <K, V> V getFromLocalStorage(ParserNamespace<K, V> type, K key) {
        Map<K, V> localNamespace = this.getLocalNamespace(type);
        return localNamespace == null ? null : (V)localNamespace.get(key);
    }

    public <K, V> Map<K, V> getAllFromLocalStorage(ParserNamespace<K, V> type) {
        return this.getLocalNamespace(type);
    }

    public <K, V> V putToLocalStorage(ParserNamespace<K, V> type, K key, V value) {
        V ret = this.ensureLocalNamespace(type).put(key, value);
        this.onNamespaceElementAdded(type, key, value);
        return ret;
    }

    public final <K, V> V putToLocalStorageIfAbsent(ParserNamespace<K, V> type, K key, V value) {
        V ret = this.ensureLocalNamespace(type).putIfAbsent(key, value);
        if (ret == null) {
            this.onNamespaceElementAdded(type, key, value);
        }
        return ret;
    }

    void sweepNamespaces() {
        this.namespaces = null;
        LOG.trace("Swept namespace storages of {}", (Object)this);
    }

    void sweepNamespaces(Map<ParserNamespace<?, ?>, SweptNamespace> toWipe) {
        switch (this.namespaces.size()) {
            case 0: {
                this.namespaces = ImmutableMap.copyOf(toWipe);
                return;
            }
            case 1: {
                this.namespaces = new HashMap(this.namespaces);
                break;
            }
        }
        this.namespaces.putAll(toWipe);
        LOG.trace("Trimmed namespace storages of {} to {}", (Object)this, this.namespaces.keySet());
    }

    private <K, V> Map<K, V> ensureLocalNamespace(ParserNamespace<K, V> type) {
        Map<K, V> ret = this.getLocalNamespace(type);
        if (ret == null) {
            this.checkLocalNamespaceAllowed(type);
            ret = new HashMap(1);
            switch (this.namespaces.size()) {
                case 0: {
                    this.namespaces = ImmutableMap.of(type, ret);
                    break;
                }
                case 1: {
                    HashMap newNamespaces = new HashMap(4);
                    Map.Entry<ParserNamespace<?, ?>, Map<?, ?>> entry = this.namespaces.entrySet().iterator().next();
                    newNamespaces.put(entry.getKey(), entry.getValue());
                    this.namespaces = newNamespaces;
                }
                default: {
                    this.namespaces.put(type, ret);
                }
            }
        }
        return ret;
    }
}

