/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStorage;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;

public abstract class NamespaceBehaviour<K, V> {
    private final @NonNull ParserNamespace<K, V> namespace;

    protected NamespaceBehaviour(ParserNamespace<K, V> namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    public final @NonNull ParserNamespace<K, V> namespace() {
        return this.namespace;
    }

    public static <K, V> @NonNull NamespaceBehaviour<K, V> global(ParserNamespace<K, V> namespace) {
        return new Global<K, V>(namespace);
    }

    public static <K, V> @NonNull NamespaceBehaviour<K, V> sourceLocal(ParserNamespace<K, V> namespace) {
        return new StorageSpecific<K, V>(namespace, NamespaceStorage.StorageType.SOURCE_LOCAL_SPECIAL);
    }

    public static <K, V> @NonNull NamespaceBehaviour<K, V> statementLocal(ParserNamespace<K, V> namespace) {
        return new StatementLocal<K, V>(namespace);
    }

    public static <K, V> @NonNull NamespaceBehaviour<K, V> rootStatementLocal(ParserNamespace<K, V> namespace) {
        return new StorageSpecific<K, V>(namespace, NamespaceStorage.StorageType.ROOT_STATEMENT_LOCAL);
    }

    public static <K, V> @NonNull NamespaceBehaviour<K, V> treeScoped(ParserNamespace<K, V> namespace) {
        return new TreeScoped<K, V>(namespace);
    }

    public abstract V getFrom(NamespaceStorage.GlobalStorage var1, NamespaceStorage var2, K var3);

    public final @Nullable Map.Entry<K, V> getFrom(NamespaceStorage.GlobalStorage global, NamespaceStorage storage, NamespaceKeyCriterion<K> criterion) {
        Map<K, V> mappings = this.getAllFrom(global, storage);
        if (mappings == null) {
            return null;
        }
        Map.Entry<K, V> match = null;
        for (Map.Entry<K, V> entry : mappings.entrySet()) {
            K key = entry.getKey();
            if (!criterion.match(key)) continue;
            if (match != null) {
                K selected = criterion.select(match.getKey(), key);
                if (selected.equals(match.getKey())) continue;
                Verify.verify((selected == key ? 1 : 0) != 0, (String)"Criterion %s selected invalid key %s from candidates [%s %s]", selected, match.getKey(), key);
            }
            match = entry;
        }
        return match;
    }

    public abstract Map<K, V> getAllFrom(NamespaceStorage.GlobalStorage var1, NamespaceStorage var2);

    public abstract void addTo(NamespaceStorage.GlobalStorage var1, NamespaceStorage var2, K var3, V var4);

    protected final V getFromLocalStorage(NamespaceStorage storage, K key) {
        return storage.getFromLocalStorage(this.namespace, key);
    }

    protected final Map<K, V> getAllFromLocalStorage(NamespaceStorage storage) {
        return storage.getAllFromLocalStorage(this.namespace);
    }

    protected final void addToStorage(NamespaceStorage storage, K key, V value) {
        storage.putToLocalStorage(this.namespace, key, value);
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("namespace", this.namespace);
    }

    private static final class Global<K, V>
    extends AbstractSpecific<K, V> {
        Global(ParserNamespace<K, V> namespace) {
            super(namespace);
        }

        @Override
        NamespaceStorage.GlobalStorage findStorage(NamespaceStorage.GlobalStorage global, NamespaceStorage storage) {
            return global;
        }
    }

    private static final class StorageSpecific<K, V>
    extends AbstractSpecific<K, V> {
        private final NamespaceStorage.StorageType type;

        StorageSpecific(ParserNamespace<K, V> namespace, NamespaceStorage.StorageType type) {
            super(namespace);
            this.type = Objects.requireNonNull(type);
        }

        @Override
        NamespaceStorage findStorage(NamespaceStorage.GlobalStorage global, NamespaceStorage storage) {
            NamespaceStorage current;
            for (current = storage; current != null && current.getStorageType() != this.type; current = current.getParentStorage()) {
            }
            return current;
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper.add("type", (Object)this.type));
        }
    }

    private static final class StatementLocal<K, V>
    extends AbstractSpecific<K, V> {
        StatementLocal(ParserNamespace<K, V> identifier) {
            super(identifier);
        }

        @Override
        NamespaceStorage findStorage(NamespaceStorage.GlobalStorage global, NamespaceStorage storage) {
            return storage;
        }
    }

    private static final class TreeScoped<K, V>
    extends NamespaceBehaviour<K, V> {
        TreeScoped(ParserNamespace<K, V> namespace) {
            super(namespace);
        }

        @Override
        public V getFrom(NamespaceStorage.GlobalStorage global, NamespaceStorage storage, K key) {
            for (NamespaceStorage current = storage; current != null; current = current.getParentStorage()) {
                Object val = this.getFromLocalStorage(current, key);
                if (val == null) continue;
                return val;
            }
            return null;
        }

        @Override
        public Map<K, V> getAllFrom(NamespaceStorage.GlobalStorage global, NamespaceStorage storage) {
            for (NamespaceStorage current = storage; current != null; current = current.getParentStorage()) {
                Map val = this.getAllFromLocalStorage(current);
                if (val == null) continue;
                return val;
            }
            return null;
        }

        @Override
        public void addTo(NamespaceStorage.GlobalStorage global, NamespaceStorage storage, K key, V value) {
            this.addToStorage(storage, key, value);
        }
    }

    private static abstract class AbstractSpecific<K, V>
    extends NamespaceBehaviour<K, V> {
        AbstractSpecific(ParserNamespace<K, V> namespace) {
            super(namespace);
        }

        @Override
        public final V getFrom(NamespaceStorage.GlobalStorage global, NamespaceStorage storage, K key) {
            return this.getFromLocalStorage(this.findStorage(global, storage), key);
        }

        @Override
        public final Map<K, V> getAllFrom(NamespaceStorage.GlobalStorage global, NamespaceStorage storage) {
            return this.getAllFromLocalStorage(this.findStorage(global, storage));
        }

        @Override
        public final void addTo(NamespaceStorage.GlobalStorage global, NamespaceStorage storage, K key, V value) {
            this.addToStorage(this.findStorage(global, storage), key, value);
        }

        abstract NamespaceStorage findStorage(NamespaceStorage.GlobalStorage var1, NamespaceStorage var2);
    }
}

