/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.xpath.api.QNameReferent;
import org.opendaylight.yangtools.yang.xpath.api.ResolvedQNameReferent;
import org.opendaylight.yangtools.yang.xpath.api.UnresolvedQNameReferent;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class YangQNameExpr
implements YangExpr,
QNameReferent {
    private static final long serialVersionUID = 1L;

    public static Unresolved of(UnresolvedQName qname) {
        return new Unresolved(qname);
    }

    public static Resolved of(QName qname) {
        return new Resolved(qname);
    }

    public static final class Unresolved
    extends YangQNameExpr
    implements UnresolvedQNameReferent {
        private static final long serialVersionUID = 1L;
        private final UnresolvedQName qname;

        Unresolved(UnresolvedQName qname) {
            this.qname = Objects.requireNonNull(qname);
        }

        @Override
        public UnresolvedQName getQName() {
            return this.qname;
        }

        public int hashCode() {
            return this.qname.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Unresolved)) return false;
            Unresolved other = (Unresolved)obj;
            if (!this.qname.equals((Object)other.qname)) return false;
            return true;
        }

        public String toString() {
            return this.qname.toString();
        }
    }

    public static final class Resolved
    extends YangQNameExpr
    implements ResolvedQNameReferent {
        private static final long serialVersionUID = 1L;
        private final QName qname;

        Resolved(QName qname) {
            this.qname = Objects.requireNonNull(qname);
        }

        @Override
        public QName getQName() {
            return this.qname;
        }

        public int hashCode() {
            return this.qname.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Resolved)) return false;
            Resolved other = (Resolved)obj;
            if (!this.qname.equals((Object)other.qname)) return false;
            return true;
        }

        public String toString() {
            return this.qname.toString();
        }
    }
}

