/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.namespace;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ModuleQNameToPrefix;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class StmtNamespaceContext
implements YangNamespaceContext {
    private static final long serialVersionUID = 1L;
    private final ImmutableBiMap<QNameModule, String> moduleToPrefix;
    private final ImmutableMap<String, QNameModule> prefixToModule;

    StmtNamespaceContext(StmtContext<?, ?, ?> ctx) {
        Map belongsTo;
        Map qnameToPrefix = ctx.namespace(ModuleQNameToPrefix.INSTANCE);
        this.moduleToPrefix = qnameToPrefix == null ? ImmutableBiMap.of() : ImmutableBiMap.copyOf((Map)qnameToPrefix);
        HashMap<String, QNameModule> additional = new HashMap<String, QNameModule>();
        Map imports = ctx.namespace(ParserNamespaces.IMPORT_PREFIX_TO_MODULECTX);
        if (imports != null) {
            for (Map.Entry entry : imports.entrySet()) {
                if (this.moduleToPrefix.containsValue(entry.getKey())) continue;
                QNameModule qnameModule = (QNameModule)ctx.namespaceItem(ParserNamespaces.MODULECTX_TO_QNAME, (Object)((StmtContext)entry.getValue()));
                if (qnameModule == null && ctx.producesDeclared(SubmoduleStatement.class)) {
                    qnameModule = (QNameModule)ctx.namespaceItem(ParserNamespaces.MODULE_NAME_TO_QNAME, (Object)((UnresolvedQName.Unqualified)ctx.namespaceItem(ParserNamespaces.BELONGSTO_PREFIX_TO_MODULE_NAME, entry.getKey())));
                }
                if (qnameModule == null) continue;
                additional.put((String)entry.getKey(), qnameModule);
            }
        }
        if (ctx.producesDeclared(SubmoduleStatement.class) && (belongsTo = ctx.namespace(ParserNamespaces.BELONGSTO_PREFIX_TO_MODULE_NAME)) != null) {
            for (Map.Entry entry : belongsTo.entrySet()) {
                QNameModule module = (QNameModule)ctx.namespaceItem(ParserNamespaces.MODULE_NAME_TO_QNAME, (Object)((UnresolvedQName.Unqualified)entry.getValue()));
                if (module == null || additional.containsKey(entry.getKey())) continue;
                additional.put((String)entry.getKey(), module);
            }
        }
        this.prefixToModule = ImmutableMap.copyOf(additional);
    }

    public String prefixForNamespace(QNameModule namespace) {
        return (String)this.moduleToPrefix.get((Object)Objects.requireNonNull(namespace));
    }

    public QNameModule namespaceForPrefix(String prefix) {
        String checked = Objects.requireNonNull(prefix);
        QNameModule normal = (QNameModule)this.moduleToPrefix.inverse().get((Object)checked);
        return normal != null ? normal : (QNameModule)this.prefixToModule.get((Object)checked);
    }
}

