/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.opendaylight.yangtools.yang.model.api.source.SourceDependency;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.spi.source.SourceInfo;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DependencyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DependencyResolver.class);
    private final ImmutableList<SourceIdentifier> resolvedSources;
    private final ImmutableList<SourceIdentifier> unresolvedSources;
    private final ImmutableMultimap<SourceIdentifier, SourceDependency> unsatisfiedImports;

    protected DependencyResolver(Map<SourceIdentifier, SourceInfo> depInfo) {
        boolean progress;
        HashSet resolved = Sets.newHashSetWithExpectedSize((int)depInfo.size());
        HashMap<SourceIdentifier, SourceInfo> pending = new HashMap<SourceIdentifier, SourceInfo>(depInfo);
        do {
            progress = false;
            Iterator<SourceInfo> it = pending.values().iterator();
            while (it.hasNext()) {
                SourceInfo dep = it.next();
                if (!this.tryResolve(resolved, dep)) continue;
                SourceIdentifier sourceId = dep.sourceId();
                LOG.debug("Resolved source {}", (Object)sourceId);
                resolved.add(sourceId);
                it.remove();
                progress = true;
            }
        } while (progress);
        this.resolvedSources = ImmutableList.copyOf((Collection)resolved);
        this.unresolvedSources = ImmutableList.copyOf(pending.keySet());
        ImmutableMultimap.Builder unstatisfied = ImmutableMultimap.builder();
        for (SourceInfo info : pending.values()) {
            SourceDependency.Import dep2;
            for (SourceDependency.Import dep2 : info.imports()) {
                if (this.isKnown(depInfo.keySet(), (SourceDependency)dep2)) continue;
                unstatisfied.put((Object)info.sourceId(), (Object)dep2);
            }
            for (SourceDependency.Import dep2 : info.includes()) {
                if (this.isKnown(depInfo.keySet(), (SourceDependency)dep2)) continue;
                unstatisfied.put((Object)info.sourceId(), (Object)dep2);
            }
            if (!(info instanceof SourceInfo.Submodule)) continue;
            SourceInfo.Submodule submodule = (SourceInfo.Submodule)info;
            dep2 = submodule.belongsTo();
            if (this.isKnown(depInfo.keySet(), (SourceDependency)dep2)) continue;
            unstatisfied.put((Object)info.sourceId(), (Object)dep2);
        }
        this.unsatisfiedImports = unstatisfied.build();
    }

    final ImmutableList<SourceIdentifier> resolvedSources() {
        return this.resolvedSources;
    }

    final ImmutableList<SourceIdentifier> unresolvedSources() {
        return this.unresolvedSources;
    }

    final ImmutableMultimap<SourceIdentifier, SourceDependency> unsatisfiedImports() {
        return this.unsatisfiedImports;
    }

    private boolean tryResolve(Collection<SourceIdentifier> resolved, SourceInfo info) {
        SourceInfo.Submodule submodule;
        SourceDependency.Import dep2;
        for (SourceDependency.Import dep2 : info.imports()) {
            if (this.isKnown(resolved, (SourceDependency)dep2)) continue;
            LOG.debug("Source {} is missing import {}", (Object)info.sourceId(), (Object)dep2);
            return false;
        }
        for (SourceDependency.Import dep2 : info.includes()) {
            if (this.isKnown(resolved, (SourceDependency)dep2)) continue;
            LOG.debug("Source {} is missing include {}", (Object)info.sourceId(), (Object)dep2);
            return false;
        }
        if (info instanceof SourceInfo.Submodule && !this.isKnown(resolved, (SourceDependency)(dep2 = (submodule = (SourceInfo.Submodule)info).belongsTo()))) {
            LOG.debug("Source {} is missing belongs-to {}", (Object)info.sourceId(), (Object)dep2);
            return false;
        }
        return true;
    }

    abstract boolean isKnown(Collection<SourceIdentifier> var1, SourceDependency var2);

    abstract YangParserConfiguration parserConfig();
}

