/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import org.eclipse.jdt.annotation.NonNull;
import tech.pantheon.triemap.KeySetIterator;
import tech.pantheon.triemap.TrieMap;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractKeySet<K, M extends TrieMap<K, ?>>
extends AbstractSet<K> {
    final @NonNull M map;

    AbstractKeySet(M map) {
        this.map = (TrieMap)Objects.requireNonNull(map);
    }

    @Override
    public final boolean addAll(Collection<? extends K> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean contains(Object o) {
        return ((TrieMap)this.map).containsKey(o);
    }

    @Override
    public final int size() {
        return ((TrieMap)this.map).size();
    }

    @Override
    public final Spliterator<K> spliterator() {
        return Spliterators.spliterator(this.immutableIterator(), Long.MAX_VALUE, this.spliteratorCharacteristics());
    }

    @Override
    public abstract KeySetIterator<K> iterator();

    final @NonNull KeySetIterator<K> immutableIterator() {
        return new KeySetIterator(((TrieMap)this.map).immutableIterator());
    }

    abstract int spliteratorCharacteristics();
}

