/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.type;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;

@Beta
public final class TypeDefinitions {
    public static final @NonNull QName BINARY = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"binary").intern();
    public static final @NonNull QName BITS = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"bits").intern();
    public static final @NonNull QName BOOLEAN = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"boolean").intern();
    public static final @NonNull QName DECIMAL64 = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"decimal64").intern();
    public static final @NonNull QName EMPTY = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"empty").intern();
    public static final @NonNull QName ENUMERATION = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"enumeration").intern();
    public static final @NonNull QName IDENTITYREF = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"identityref").intern();
    public static final @NonNull QName INT8 = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"int8").intern();
    public static final @NonNull QName INT16 = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"int16").intern();
    public static final @NonNull QName INT32 = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"int32").intern();
    public static final @NonNull QName INT64 = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"int64").intern();
    public static final @NonNull QName STRING = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"string").intern();
    public static final @NonNull QName UNION = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"union").intern();
    public static final @NonNull QName LEAFREF = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"leafref").intern();
    public static final @NonNull QName INSTANCE_IDENTIFIER = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"instance-identifier").intern();
    public static final @NonNull QName UINT8 = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"uint8").intern();
    public static final @NonNull QName UINT16 = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"uint16").intern();
    public static final @NonNull QName UINT32 = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"uint32").intern();
    public static final @NonNull QName UINT64 = QName.create((QNameModule)YangConstants.RFC6020_YANG_MODULE, (String)"uint64").intern();

    private TypeDefinitions() {
    }

    static int basicHashCode(@NonNull TypeDefinition<?> type) {
        return Objects.hash(type.getQName(), type.getUnknownSchemaNodes(), type.getBaseType(), type.getUnits().orElse(null), type.getDefaultValue().orElse(null));
    }

    static int hashCode(@NonNull RangeRestrictedTypeDefinition<?, ?> type) {
        return Objects.hash(type.getQName(), type.getUnknownSchemaNodes(), type.getBaseType(), type.getUnits().orElse(null), type.getDefaultValue().orElse(null), type.getRangeConstraint().orElse(null));
    }

    static <T extends RangeRestrictedTypeDefinition<T, ?>> boolean equals(@NonNull Class<T> clazz, @NonNull T type, @Nullable Object obj) {
        if (type == obj) {
            return true;
        }
        @Nullable RangeRestrictedTypeDefinition other = (RangeRestrictedTypeDefinition)TypeDefinitions.castIfEquals(clazz, type, obj);
        return other != null && type.getRangeConstraint().equals(other.getRangeConstraint());
    }

    static @NonNull String toString(@NonNull RangeRestrictedTypeDefinition<?, ?> type) {
        return TypeDefinitions.toStringHelper(type).toString();
    }

    static <T extends TypeDefinition<T>> @Nullable T castIfEquals(@NonNull Class<T> clazz, @NonNull T type, @Nullable Object obj) {
        if (!clazz.isInstance(obj)) {
            return null;
        }
        @NonNull TypeDefinition other = (TypeDefinition)clazz.cast(obj);
        return (T)(Objects.equals(type.getQName(), other.getQName()) && Objects.equals(type.getBaseType(), other.getBaseType()) && Objects.equals(type.getDefaultValue(), other.getDefaultValue()) && Objects.equals(type.getUnknownSchemaNodes(), other.getUnknownSchemaNodes()) && Objects.equals(type.getUnits(), other.getUnits()) ? other : null);
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper toStringHelper(@NonNull TypeDefinition<?> type) {
        return MoreObjects.toStringHelper(type).omitNullValues().add("name", (Object)type.getQName()).add("baseType", type.getBaseType()).add("default", type.getDefaultValue().orElse(null)).add("description", type.getDescription().orElse(null)).add("reference", type.getReference().orElse(null)).add("status", (Object)type.getStatus()).add("units", type.getUnits().orElse(null));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper toStringHelper(@NonNull RangeRestrictedTypeDefinition<?, ?> type) {
        return TypeDefinitions.toStringHelper(type).add("range", type.getRangeConstraint().orElse(null));
    }
}

