/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;

@Beta
public abstract class UnresolvedNumber
extends Number
implements Immutable {
    private static final @NonNull UnresolvedNumber MAX = new UnresolvedNumber(){
        private static final long serialVersionUID = 1L;

        @Override
        public <T extends Number> T resolveLength(Range<? extends T> span) {
            return (T)UnresolvedNumber.resolve((Number)((Object)span.upperEndpoint()));
        }

        @Override
        public <T extends Number> T resolveRange(Range<? extends T> span) {
            return (T)UnresolvedNumber.resolve((Number)((Object)span.upperEndpoint()));
        }

        @Override
        public String toString() {
            return "max";
        }

        private Object readResolve() {
            return MAX;
        }
    };
    private static final @NonNull UnresolvedNumber MIN = new UnresolvedNumber(){
        private static final long serialVersionUID = 1L;

        @Override
        public <T extends Number> T resolveLength(Range<? extends T> span) {
            return (T)UnresolvedNumber.resolve((Number)((Object)span.lowerEndpoint()));
        }

        @Override
        public <T extends Number> T resolveRange(Range<? extends T> span) {
            return (T)UnresolvedNumber.resolve((Number)((Object)span.lowerEndpoint()));
        }

        @Override
        public String toString() {
            return "min";
        }

        private Object readResolve() {
            return MIN;
        }
    };
    private static final long serialVersionUID = 1L;

    UnresolvedNumber() {
    }

    public static @NonNull UnresolvedNumber min() {
        return MIN;
    }

    public static @NonNull UnresolvedNumber max() {
        return MAX;
    }

    @Override
    public final int intValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long longValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final float floatValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final double doubleValue() {
        throw new UnsupportedOperationException();
    }

    private static <T extends Number> T resolve(T number) {
        Preconditions.checkArgument((!(number instanceof UnresolvedNumber) ? 1 : 0) != 0);
        return number;
    }

    public abstract <T extends Number> @NonNull T resolveLength(Range<? extends T> var1);

    public abstract <T extends Number> @NonNull T resolveRange(Range<? extends T> var1);

    public abstract String toString();
}

