/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.util.concurrent.AsyncNotifyingListeningExecutorService;
import org.opendaylight.yangtools.util.concurrent.SettableBoolean;
import org.opendaylight.yangtools.util.concurrent.SettableBooleanThreadLocal;

public class DeadlockDetectingListeningExecutorService
extends AsyncNotifyingListeningExecutorService {
    private final @NonNull SettableBooleanThreadLocal deadlockDetector = new SettableBooleanThreadLocal();
    private final @NonNull Supplier<Exception> deadlockExceptionFunction;

    public DeadlockDetectingListeningExecutorService(@NonNull ExecutorService delegate, @NonNull Supplier<Exception> deadlockExceptionSupplier) {
        this(delegate, deadlockExceptionSupplier, null);
    }

    public DeadlockDetectingListeningExecutorService(@NonNull ExecutorService delegate, @NonNull Supplier<Exception> deadlockExceptionSupplier, @Nullable Executor listenableFutureExecutor) {
        super(delegate, listenableFutureExecutor);
        this.deadlockExceptionFunction = Objects.requireNonNull(deadlockExceptionSupplier);
    }

    @Override
    public void execute(Runnable command) {
        this.getDelegate().execute(this.wrapRunnable(command));
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return this.wrapListenableFuture(super.submit(this.wrapCallable(task)));
    }

    @Override
    public ListenableFuture<?> submit(Runnable task) {
        return this.wrapListenableFuture(super.submit(this.wrapRunnable(task)));
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        return this.wrapListenableFuture(super.submit(this.wrapRunnable(task), result));
    }

    public void cleanStateForCurrentThread() {
        this.deadlockDetector.remove();
    }

    private @NonNull SettableBoolean primeDetector() {
        SettableBoolean b = (SettableBoolean)this.deadlockDetector.get();
        Preconditions.checkState((!b.isSet() ? 1 : 0) != 0, (String)"Detector for {} has already been primed", (Object)((Object)this));
        b.set();
        return b;
    }

    private @NonNull Runnable wrapRunnable(@Nullable Runnable task) {
        Objects.requireNonNull(task);
        return () -> {
            SettableBoolean b = this.primeDetector();
            try {
                task.run();
            }
            finally {
                b.reset();
            }
        };
    }

    private <T> @NonNull Callable<T> wrapCallable(@NonNull Callable<T> task) {
        Objects.requireNonNull(task);
        return () -> {
            SettableBoolean b = this.primeDetector();
            try {
                Object v = task.call();
                return v;
            }
            finally {
                b.reset();
            }
        };
    }

    private <T> @NonNull ListenableFuture<T> wrapListenableFuture(@NonNull ListenableFuture<T> delegate) {
        return new ForwardingListenableFuture.SimpleForwardingListenableFuture<T>(delegate){

            public T get() throws InterruptedException, ExecutionException {
                this.checkDeadLockDetectorTL();
                return super.get();
            }

            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                this.checkDeadLockDetectorTL();
                return super.get(timeout, unit);
            }

            void checkDeadLockDetectorTL() throws ExecutionException {
                if (((SettableBoolean)DeadlockDetectingListeningExecutorService.this.deadlockDetector.get()).isSet()) {
                    throw new ExecutionException("A potential deadlock was detected.", DeadlockDetectingListeningExecutorService.this.deadlockExceptionFunction.get());
                }
            }
        };
    }
}

