/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public enum ErrorSeverity {
    ERROR("error"),
    WARNING("warning");

    private static final Map<String, ErrorSeverity> BY_ELEMENT_BODY;
    private final String elementBody;

    private ErrorSeverity(String elementName) {
        this.elementBody = Objects.requireNonNull(elementName);
    }

    public String elementBody() {
        return this.elementBody;
    }

    public static @Nullable ErrorSeverity forElementBody(String elementBody) {
        return BY_ELEMENT_BODY.get(Objects.requireNonNull(elementBody));
    }

    static {
        BY_ELEMENT_BODY = Maps.uniqueIndex(Arrays.asList(ErrorSeverity.values()), ErrorSeverity::elementBody);
    }
}

