/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public final class WritableObjects {
    private WritableObjects() {
    }

    public static void writeLong(DataOutput out, long value) throws IOException {
        WritableObjects.writeLong(out, value, 0);
    }

    public static void writeLong(DataOutput out, long value, int flags) throws IOException {
        Preconditions.checkArgument(((flags & 0xFFFFFF0F) == 0 ? 1 : 0) != 0, (String)"Invalid flags %s", (int)flags);
        int bytes = WritableObjects.valueBytes(value);
        out.writeByte(bytes | flags);
        WritableObjects.writeValue(out, value, bytes);
    }

    public static long readLong(DataInput in) throws IOException {
        return WritableObjects.readLongBody(in, WritableObjects.readLongHeader(in));
    }

    public static byte readLongHeader(DataInput in) throws IOException {
        return in.readByte();
    }

    public static int longHeaderFlags(byte header) {
        return header & 0xF0;
    }

    public static long readLongBody(DataInput in, byte header) throws IOException {
        int bytes = header & 0xF;
        if (bytes >= 8) {
            return in.readLong();
        }
        if (bytes <= 0) {
            return 0L;
        }
        long value = 0L;
        if (bytes >= 4) {
            value = ((long)in.readInt() & 0xFFFFFFFFL) << (bytes -= 4) * 8;
        }
        if (bytes >= 2) {
            value |= (long)(in.readUnsignedShort() << (bytes -= 2) * 8);
        }
        if (bytes > 0) {
            value |= (long)in.readUnsignedByte();
        }
        return value;
    }

    public static void writeLongs(DataOutput out, long value0, long value1) throws IOException {
        int clen = WritableObjects.valueBytes(value1);
        WritableObjects.writeLong(out, value0, clen << 4);
        WritableObjects.writeValue(out, value1, clen);
    }

    public static long readFirstLong(DataInput in, byte header) throws IOException {
        return WritableObjects.readLongBody(in, header);
    }

    public static long readSecondLong(DataInput in, byte header) throws IOException {
        return WritableObjects.readLongBody(in, (byte)(header >> 4));
    }

    private static void writeValue(DataOutput out, long value, int bytes) throws IOException {
        if (bytes < 8) {
            int left = bytes;
            if (left >= 4) {
                out.writeInt((int)(value >>> (left -= 4) * 8));
            }
            if (left >= 2) {
                out.writeShort((int)(value >>> (left -= 2) * 8));
            }
            if (left > 0) {
                out.writeByte((int)(value & 0xFFL));
            }
        } else {
            out.writeLong(value);
        }
    }

    private static int valueBytes(long value) {
        if ((value & 0xFFFFFFFF00000000L) != 0L) {
            if ((value & 0xFFFF000000000000L) != 0L) {
                return (value & 0xFF00000000000000L) != 0L ? 8 : 7;
            }
            return (value & 0xFF0000000000L) != 0L ? 6 : 5;
        }
        if ((value & 0xFFFFFFFFL) != 0L) {
            if ((value & 0xFFFF0000L) != 0L) {
                return (value & 0xFF000000L) != 0L ? 4 : 3;
            }
            return (value & 0xFF00L) != 0L ? 2 : 1;
        }
        return 0;
    }
}

