/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.UndeclaredStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta.AbstractImplicitStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameWithFlagsEffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class LeafStatementSupport
extends AbstractImplicitStatementSupport<LeafStatement, LeafEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.LEAF).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addMandatory((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.UNITS).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();

    public LeafStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.LEAF, LeafStatementSupport.instantiatedPolicy(), config, SUBSTATEMENT_VALIDATOR);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<QName, LeafStatement, LeafEffectiveStatement> ctx) {
        super.onFullDefinitionDeclared(ctx);
        StmtContextUtils.validateIfFeatureAndWhenOnListKeys(ctx);
    }

    protected LeafStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createLeaf((QName)((QName)ctx.getArgument()), substatements);
    }

    protected LeafStatement attachDeclarationReference(LeafStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateLeaf((LeafStatement)stmt, (DeclarationReference)reference);
    }

    public LeafEffectiveStatement copyEffective(EffectiveStmtCtx.Current<QName, LeafStatement> stmt, LeafEffectiveStatement original) {
        return EffectiveStatements.copyLeaf((LeafEffectiveStatement)original, (QName)((QName)stmt.getArgument()), (int)LeafStatementSupport.computeFlags(stmt, original.effectiveSubstatements()));
    }

    protected LeafEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, LeafStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        LeafStatementSupport.validateEffective(stmt, substatements);
        return EffectiveStatements.createLeaf((LeafStatement)((LeafStatement)stmt.declared()), (QName)((QName)stmt.getArgument()), (int)LeafStatementSupport.computeFlags(stmt, substatements), substatements);
    }

    @Override
    LeafEffectiveStatement createUndeclaredEffective(EffectiveStmtCtx.UndeclaredCurrent<QName, LeafStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        LeafStatementSupport.validateEffective(stmt, substatements);
        return UndeclaredStatements.createLeaf((QName)((QName)stmt.getArgument()), (int)LeafStatementSupport.computeFlags(stmt, substatements), substatements);
    }

    private static void validateEffective(@NonNull BoundStmtCtx<QName> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)SourceException.throwIfNull((Object)((TypeEffectiveStatement)LeafStatementSupport.findFirstStatement(substatements, TypeEffectiveStatement.class)), stmt, (String)"Leaf is missing a 'type' statement", (Object[])new Object[0]);
        String dflt = (String)LeafStatementSupport.findFirstArgument(substatements, DefaultEffectiveStatement.class, null);
        SourceException.throwIf((boolean)EffectiveStmtUtils.hasDefaultValueMarkedWithIfFeature(stmt.yangVersion(), typeStmt, dflt), stmt, (String)"Leaf '%s' has default value '%s' marked with an if-feature statement.", (Object[])new Object[]{stmt.argument(), dflt});
    }

    public EffectiveStatementState extractEffectiveState(LeafEffectiveStatement stmt) {
        Verify.verify((boolean)(stmt instanceof LeafSchemaNode), (String)"Unexpected statement %s", (Object)stmt);
        LeafSchemaNode schema = (LeafSchemaNode)stmt;
        return new QNameWithFlagsEffectiveStatementState((QName)stmt.argument(), new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)schema).setStatus(schema.getStatus()).setConfiguration((Boolean)schema.effectiveConfig().orElse(null)).setMandatory(schema.isMandatory()).toFlags());
    }

    private static int computeFlags(EffectiveStmtCtx.Current<?, ?> stmt, Collection<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)stmt.history()).setStatus((Status)LeafStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, (Object)Status.CURRENT)).setConfiguration(stmt.effectiveConfig().asNullable()).setMandatory(((Boolean)LeafStatementSupport.findFirstArgument(substatements, MandatoryEffectiveStatement.class, (Object)Boolean.FALSE)).booleanValue()).toFlags();
    }
}

