/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.YangDataName;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.SchemaTreeInference;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.spi.AbstractEffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.spi.DefaultSchemaTreeInference;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathAxis;
import org.slf4j.LoggerFactory;

@Beta
public final class SchemaInferenceStack
implements Mutable,
LeafrefResolver {
    private static final String VERIFY_DEFAULT_SCHEMA_TREE_INFERENCE_PROP = "org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack.verifyDefaultSchemaTreeInference";
    private static final boolean VERIFY_DEFAULT_SCHEMA_TREE_INFERENCE = Boolean.getBoolean("org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack.verifyDefaultSchemaTreeInference");
    private final @NonNull EffectiveModelContext modelContext;
    private final ArrayDeque<EffectiveStatement<?, ?>> deque;
    private @Nullable ModuleEffectiveStatement currentModule;
    private int groupingDepth;
    private boolean clean;

    private SchemaInferenceStack(EffectiveModelContext effectiveModel, int expectedSize) {
        this.deque = new ArrayDeque(expectedSize);
        this.modelContext = Objects.requireNonNull(effectiveModel);
        this.clean = true;
    }

    private SchemaInferenceStack(SchemaInferenceStack source) {
        this.deque = source.deque.clone();
        this.modelContext = source.modelContext;
        this.currentModule = source.currentModule;
        this.groupingDepth = source.groupingDepth;
        this.clean = source.clean;
    }

    private SchemaInferenceStack(EffectiveModelContext modelContext, ArrayDeque<EffectiveStatement<?, ?>> deque, ModuleEffectiveStatement currentModule, int groupingDepth, boolean clean) {
        this.modelContext = Objects.requireNonNull(modelContext);
        this.deque = deque.clone();
        this.currentModule = currentModule;
        this.groupingDepth = groupingDepth;
        this.clean = clean;
    }

    private SchemaInferenceStack(EffectiveModelContext effectiveModel) {
        this.modelContext = Objects.requireNonNull(effectiveModel);
        this.deque = new ArrayDeque();
        this.clean = true;
    }

    public static @NonNull SchemaInferenceStack of(EffectiveModelContext effectiveModel) {
        return new SchemaInferenceStack(effectiveModel);
    }

    public static @NonNull SchemaInferenceStack of(EffectiveModelContext effectiveModel, SchemaNodeIdentifier.Absolute path) {
        SchemaInferenceStack ret = new SchemaInferenceStack(effectiveModel);
        path.getNodeIdentifiers().forEach(ret::enterSchemaTree);
        return ret;
    }

    public static @NonNull SchemaInferenceStack ofInference(EffectiveStatementInference inference) {
        if (inference.statementPath().isEmpty()) {
            return new SchemaInferenceStack(inference.modelContext());
        }
        if (inference instanceof SchemaTreeInference) {
            SchemaTreeInference sti = (SchemaTreeInference)inference;
            return SchemaInferenceStack.ofInference(sti);
        }
        if (inference instanceof Inference) {
            Inference inf = (Inference)inference;
            return inf.toSchemaInferenceStack();
        }
        throw new IllegalArgumentException("Unsupported Inference " + inference);
    }

    public static @NonNull SchemaInferenceStack ofInference(SchemaTreeInference inference) {
        SchemaInferenceStack schemaInferenceStack;
        if (inference instanceof DefaultSchemaTreeInference) {
            DefaultSchemaTreeInference dsti = (DefaultSchemaTreeInference)inference;
            schemaInferenceStack = SchemaInferenceStack.ofInference(dsti);
        } else {
            schemaInferenceStack = SchemaInferenceStack.of(inference.modelContext(), inference.toSchemaNodeIdentifier());
        }
        return schemaInferenceStack;
    }

    public static @NonNull SchemaInferenceStack ofInference(DefaultSchemaTreeInference inference) {
        return VERIFY_DEFAULT_SCHEMA_TREE_INFERENCE ? SchemaInferenceStack.ofUntrusted(inference) : SchemaInferenceStack.ofTrusted(inference);
    }

    private static @NonNull SchemaInferenceStack ofTrusted(DefaultSchemaTreeInference inference) {
        List path = inference.statementPath();
        SchemaInferenceStack ret = new SchemaInferenceStack(inference.modelContext(), path.size());
        ret.currentModule = ret.getModule((QName)((SchemaTreeEffectiveStatement)path.get(0)).argument());
        ret.deque.addAll(path);
        return ret;
    }

    @VisibleForTesting
    static @NonNull SchemaInferenceStack ofUntrusted(DefaultSchemaTreeInference inference) {
        SchemaInferenceStack ret = SchemaInferenceStack.of(inference.modelContext(), inference.toSchemaNodeIdentifier());
        if (!Iterables.elementsEqual(ret.deque, (Iterable)inference.statementPath())) {
            throw new IllegalArgumentException("Provided " + inference + " is not consistent with resolved path " + ret.toSchemaTreeInference());
        }
        return ret;
    }

    public static @NonNull SchemaInferenceStack ofDataTreePath(EffectiveModelContext effectiveModel, QName ... path) {
        SchemaInferenceStack ret = new SchemaInferenceStack(effectiveModel);
        for (QName qname : path) {
            ret.enterDataTree(qname);
        }
        return ret;
    }

    public @NonNull EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    public @NonNull SchemaInferenceStack copy() {
        return new SchemaInferenceStack(this);
    }

    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public @NonNull EffectiveStatement<?, ?> currentStatement() {
        return SchemaInferenceStack.checkNonNullState(this.deque.peekLast());
    }

    public @NonNull ModuleEffectiveStatement currentModule() {
        return SchemaInferenceStack.checkNonNullState(this.currentModule);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean inInstantiatedContext() {
        if (this.groupingDepth != 0) return false;
        if (this.deque.isEmpty()) return false;
        if (!this.deque.stream().allMatch(SchemaTreeEffectiveStatement.class::isInstance)) return false;
        return true;
    }

    public boolean inGrouping() {
        return this.groupingDepth != 0;
    }

    public @NonNull Status effectiveStatus() {
        Iterator<EffectiveStatement<?, ?>> it = this.reconstructDeque().descendingIterator();
        while (it.hasNext()) {
            Optional optStatus = it.next().findFirstEffectiveSubstatementArgument(StatusEffectiveStatement.class);
            if (!optStatus.isPresent()) continue;
            return (Status)optStatus.orElseThrow();
        }
        return Status.CURRENT;
    }

    public void clear() {
        this.deque.clear();
        this.currentModule = null;
        this.groupingDepth = 0;
        this.clean = true;
    }

    public @NonNull ChoiceEffectiveStatement enterChoice(QName nodeIdentifier) {
        QName nodeId = Objects.requireNonNull(nodeIdentifier);
        EffectiveStatement<?, ?> parent = this.deque.peekLast();
        if (parent instanceof ChoiceEffectiveStatement) {
            ChoiceEffectiveStatement choice = (ChoiceEffectiveStatement)parent;
            return this.enterChoice(choice, nodeId);
        }
        SchemaTreeEffectiveStatement<?> result = this.enterSchemaTree(nodeId);
        if (result instanceof ChoiceEffectiveStatement) {
            ChoiceEffectiveStatement choice = (ChoiceEffectiveStatement)result;
            return choice;
        }
        this.exit();
        if (parent != null) {
            throw SchemaInferenceStack.notPresent(parent, "Choice", nodeId);
        }
        throw new IllegalArgumentException("Choice " + nodeId + " not present");
    }

    private @NonNull ChoiceEffectiveStatement enterChoice(@NonNull ChoiceEffectiveStatement parent, @NonNull QName nodeIdentifier) {
        for (EffectiveStatement stmt : parent.effectiveSubstatements()) {
            if (!(stmt instanceof CaseEffectiveStatement)) continue;
            CaseEffectiveStatement caze = (CaseEffectiveStatement)stmt;
            Optional<ChoiceEffectiveStatement> optMatch = caze.findSchemaTreeNode(nodeIdentifier).filter(ChoiceEffectiveStatement.class::isInstance).map(ChoiceEffectiveStatement.class::cast);
            if (!optMatch.isPresent()) continue;
            ChoiceEffectiveStatement match = optMatch.orElseThrow();
            this.deque.addLast((EffectiveStatement<?, ?>)match);
            this.clean = false;
            return match;
        }
        throw SchemaInferenceStack.notPresent(parent, "Choice", nodeIdentifier);
    }

    public @NonNull GroupingEffectiveStatement enterGrouping(QName nodeIdentifier) {
        return this.pushGrouping(Objects.requireNonNull(nodeIdentifier));
    }

    public @NonNull SchemaTreeEffectiveStatement<?> enterSchemaTree(QName nodeIdentifier) {
        return this.pushSchema(Objects.requireNonNull(nodeIdentifier));
    }

    public @NonNull SchemaTreeEffectiveStatement<?> enterSchemaTree(SchemaNodeIdentifier nodeIdentifier) {
        SchemaTreeEffectiveStatement<?> ret;
        if (nodeIdentifier instanceof SchemaNodeIdentifier.Absolute) {
            this.clear();
        }
        Iterator it = nodeIdentifier.getNodeIdentifiers().iterator();
        do {
            ret = this.enterSchemaTree((QName)it.next());
        } while (it.hasNext());
        return ret;
    }

    public @NonNull DataTreeEffectiveStatement<?> enterDataTree(QName nodeIdentifier) {
        return this.pushData(Objects.requireNonNull(nodeIdentifier));
    }

    public @NonNull TypedefEffectiveStatement enterTypedef(QName nodeIdentifier) {
        return this.pushTypedef(Objects.requireNonNull(nodeIdentifier));
    }

    public @NonNull YangDataEffectiveStatement enterYangData(YangDataName name) {
        if (!this.isEmpty()) {
            throw new IllegalStateException("Cannot lookup yang-data in a non-empty stack");
        }
        YangDataName checkedName = Objects.requireNonNull(name);
        QNameModule namespace = name.module();
        ModuleEffectiveStatement module = (ModuleEffectiveStatement)this.modelContext.getModuleStatements().get(namespace);
        if (module == null) {
            throw new IllegalArgumentException("Module for " + namespace + " not found");
        }
        YangDataEffectiveStatement ret = module.streamEffectiveSubstatements(YangDataEffectiveStatement.class).filter(stmt -> checkedName.equals(stmt.argument())).findFirst().orElseThrow(() -> new IllegalArgumentException("yang-data " + checkedName.name() + " not present in " + namespace));
        this.deque.addLast((EffectiveStatement<?, ?>)ret);
        this.currentModule = module;
        return ret;
    }

    public @NonNull EffectiveStatement<?, ?> exit() {
        EffectiveStatement<?, ?> prev = this.deque.removeLast();
        if (prev instanceof GroupingEffectiveStatement) {
            --this.groupingDepth;
        }
        if (this.deque.isEmpty()) {
            this.currentModule = null;
            this.clean = true;
        }
        return prev;
    }

    public @NonNull DataTreeEffectiveStatement<?> exitToDataTree() {
        EffectiveStatement<?, ?> child = this.exit();
        if (!(child instanceof DataTreeEffectiveStatement)) {
            throw new IllegalStateException("Unexpected current " + child);
        }
        DataTreeEffectiveStatement ret = (DataTreeEffectiveStatement)child;
        EffectiveStatement<?, ?> parent = this.deque.peekLast();
        while (parent instanceof ChoiceEffectiveStatement || parent instanceof CaseEffectiveStatement) {
            this.deque.pollLast();
            parent = this.deque.peekLast();
        }
        if (parent == null || parent instanceof DataTreeAwareEffectiveStatement) {
            return ret;
        }
        throw new IllegalStateException("Unexpected parent " + parent);
    }

    @Override
    public TypeDefinition<?> resolveLeafref(LeafrefTypeDefinition type) {
        TypeDefinition result;
        SchemaInferenceStack tmp = this.copy();
        LeafrefTypeDefinition current = type;
        while (true) {
            EffectiveStatement<?, ?> resolved;
            if (!((resolved = tmp.resolvePathExpression(current.getPathStatement())) instanceof TypeAware)) {
                throw new IllegalStateException("Unexpected result " + resolved + " resultion of " + type);
            }
            TypeAware typeAware = (TypeAware)resolved;
            result = typeAware.getType();
            if (!(result instanceof LeafrefTypeDefinition)) break;
            LeafrefTypeDefinition leafref = (LeafrefTypeDefinition)result;
            if (result == type) {
                throw new IllegalArgumentException("Resolution of " + type + " loops back onto itself via " + current);
            }
            current = leafref;
        }
        return result;
    }

    public @NonNull EffectiveStatement<?, ?> resolvePathExpression(PathExpression path) {
        PathExpression.Steps steps = path.getSteps();
        if (steps instanceof PathExpression.LocationPathSteps) {
            PathExpression.LocationPathSteps location = (PathExpression.LocationPathSteps)steps;
            return this.resolveLocationPath(location.getLocationPath());
        }
        if (steps instanceof PathExpression.DerefSteps) {
            PathExpression.DerefSteps deref = (PathExpression.DerefSteps)steps;
            return this.resolveDeref(deref);
        }
        throw new VerifyException("Unhandled steps " + steps);
    }

    private @NonNull EffectiveStatement<?, ?> resolveDeref(PathExpression.DerefSteps deref) {
        EffectiveStatement<?, ?> leafRefSchemaNode = this.currentStatement();
        YangLocationPath.Relative derefArg = deref.getDerefArgument();
        EffectiveStatement<?, ?> derefStmt = this.resolveLocationPath((YangLocationPath)derefArg);
        if (derefStmt == null) {
            throw new IllegalArgumentException("Cannot find deref(" + derefArg + ") target node in context of %s" + leafRefSchemaNode);
        }
        if (!(derefStmt instanceof TypedDataSchemaNode)) {
            throw new IllegalArgumentException("deref(" + derefArg + ") resolved to non-typed " + derefStmt + " in context of " + leafRefSchemaNode);
        }
        TypedDataSchemaNode typed = (TypedDataSchemaNode)derefStmt;
        TypeDefinition targetType = typed.getType();
        if (targetType instanceof InstanceIdentifierTypeDefinition) {
            throw new UnsupportedOperationException("Cannot infer instance-identifier reference " + targetType);
        }
        if (!(targetType instanceof LeafrefTypeDefinition)) {
            throw new IllegalArgumentException("Illegal target type " + targetType);
        }
        LeafrefTypeDefinition leafref = (LeafrefTypeDefinition)targetType;
        PathExpression dereferencedLeafRefPath = leafref.getPathStatement();
        EffectiveStatement<?, ?> derefNode = this.resolvePathExpression(dereferencedLeafRefPath);
        Preconditions.checkArgument((derefStmt != null ? 1 : 0) != 0, (String)"Can not find target node of dereferenced node %s", derefStmt);
        Preconditions.checkArgument((boolean)(derefNode instanceof LeafSchemaNode), (String)"Unexpected %s reference in %s", (Object)deref, (Object)dereferencedLeafRefPath);
        return this.resolveLocationPath((YangLocationPath)deref.getRelativePath());
    }

    private @NonNull EffectiveStatement<?, ?> resolveLocationPath(YangLocationPath path) {
        QNameModule defaultNamespace;
        QNameModule qNameModule = defaultNamespace = this.deque.isEmpty() ? null : ((QName)this.deque.peekLast().argument()).getModule();
        if (path.isAbsolute()) {
            this.clear();
        }
        DataTreeEffectiveStatement<?> current = null;
        block6: for (YangLocationPath.Step step : path.getSteps()) {
            YangXPathAxis axis = step.getAxis();
            switch (axis) {
                case PARENT: {
                    Verify.verify((boolean)(step instanceof YangLocationPath.AxisStep), (String)"Unexpected parent step %s", (Object)step);
                    try {
                        current = this.exitToDataTree();
                        continue block6;
                    }
                    catch (IllegalStateException | NoSuchElementException e) {
                        throw new IllegalArgumentException("Illegal parent access in " + path, e);
                    }
                }
                case CHILD: {
                    if (step instanceof YangLocationPath.QNameStep) {
                        YangLocationPath.QNameStep qnameStep = (YangLocationPath.QNameStep)step;
                        current = this.enterChild(qnameStep, defaultNamespace);
                        continue block6;
                    }
                    throw new VerifyException("Unexpected child step " + step);
                }
            }
            throw new VerifyException("Unexpected step " + step);
        }
        return (EffectiveStatement)Verify.verifyNotNull(current);
    }

    private @NonNull EffectiveStatement<?, ?> enterChild(YangLocationPath.QNameStep step, QNameModule defaultNamespace) {
        QName qname;
        AbstractQName toResolve = step.getQName();
        if (toResolve instanceof QName) {
            QName qnameToResolve;
            qname = qnameToResolve = (QName)toResolve;
        } else if (toResolve instanceof UnresolvedQName.Unqualified) {
            UnresolvedQName.Unqualified unqual = (UnresolvedQName.Unqualified)toResolve;
            if (defaultNamespace == null) {
                throw new IllegalArgumentException("Can not find target module of step " + step);
            }
            qname = unqual.bindTo(defaultNamespace);
        } else {
            throw new VerifyException("Unexpected child step QName " + toResolve);
        }
        return this.enterDataTree(qname);
    }

    public @NonNull Inference toInference() {
        return new Inference(this.modelContext, (ArrayDeque<EffectiveStatement<?, ?>>)this.deque.clone(), this.currentModule, this.groupingDepth, this.clean);
    }

    public @NonNull SchemaTreeInference toSchemaTreeInference() {
        this.checkInInstantiatedContext();
        return DefaultSchemaTreeInference.unsafeOf((EffectiveModelContext)this.modelContext, (ImmutableList)((ImmutableList)this.reconstructDeque().stream().map(stmt -> (SchemaTreeEffectiveStatement)stmt).collect(ImmutableList.toImmutableList())));
    }

    private ArrayDeque<EffectiveStatement<?, ?>> reconstructDeque() {
        return this.clean ? this.deque : this.reconstructSchemaInferenceStack().deque;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SchemaNodeIdentifier.Absolute toSchemaNodeIdentifier() {
        this.checkInInstantiatedContext();
        return SchemaNodeIdentifier.Absolute.of(this.simplePathFromRoot());
    }

    private void checkInInstantiatedContext() {
        if (!this.inInstantiatedContext()) {
            throw new IllegalStateException("Cannot convert uninstantiated context " + this);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", this.deque).toString();
    }

    private @NonNull GroupingEffectiveStatement pushGrouping(@NonNull QName nodeIdentifier) {
        EffectiveStatement<?, ?> parent = this.deque.peekLast();
        return parent != null ? this.pushGrouping(parent, nodeIdentifier) : this.pushFirstGrouping(nodeIdentifier);
    }

    private @NonNull GroupingEffectiveStatement pushGrouping(@NonNull EffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        GroupingEffectiveStatement ret = parent.streamEffectiveSubstatements(GroupingEffectiveStatement.class).filter(stmt -> nodeIdentifier.equals(stmt.argument())).findFirst().orElseThrow(() -> SchemaInferenceStack.notPresent(parent, "Grouping", nodeIdentifier));
        this.deque.addLast((EffectiveStatement<?, ?>)ret);
        ++this.groupingDepth;
        return ret;
    }

    private @NonNull GroupingEffectiveStatement pushFirstGrouping(@NonNull QName nodeIdentifier) {
        ModuleEffectiveStatement module = this.getModule(nodeIdentifier);
        GroupingEffectiveStatement ret = this.pushGrouping((EffectiveStatement<?, ?>)module, nodeIdentifier);
        this.currentModule = module;
        return ret;
    }

    private @NonNull SchemaTreeEffectiveStatement<?> pushSchema(@NonNull QName nodeIdentifier) {
        EffectiveStatement<?, ?> parent = this.deque.peekLast();
        return parent != null ? this.pushSchema(parent, nodeIdentifier) : this.pushFirstSchema(nodeIdentifier);
    }

    private @NonNull SchemaTreeEffectiveStatement<?> pushSchema(EffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        if (parent instanceof SchemaTreeAwareEffectiveStatement) {
            SchemaTreeAwareEffectiveStatement schemaTreeParent = (SchemaTreeAwareEffectiveStatement)parent;
            return this.pushSchema(schemaTreeParent, nodeIdentifier);
        }
        throw new IllegalStateException("Cannot descend schema tree at " + parent);
    }

    private @NonNull SchemaTreeEffectiveStatement<?> pushSchema(@NonNull SchemaTreeAwareEffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        SchemaTreeEffectiveStatement ret = (SchemaTreeEffectiveStatement)parent.findSchemaTreeNode(nodeIdentifier).orElseThrow(() -> SchemaInferenceStack.notPresent(parent, "Schema tree child ", nodeIdentifier));
        this.deque.addLast((EffectiveStatement<?, ?>)ret);
        return ret;
    }

    private @NonNull SchemaTreeEffectiveStatement<?> pushFirstSchema(@NonNull QName nodeIdentifier) {
        ModuleEffectiveStatement module = this.getModule(nodeIdentifier);
        SchemaTreeEffectiveStatement<?> ret = this.pushSchema((SchemaTreeAwareEffectiveStatement<?, ?>)module, nodeIdentifier);
        this.currentModule = module;
        return ret;
    }

    private @NonNull DataTreeEffectiveStatement<?> pushData(@NonNull QName nodeIdentifier) {
        EffectiveStatement<?, ?> parent = this.deque.peekLast();
        return parent != null ? this.pushData(parent, nodeIdentifier) : this.pushFirstData(nodeIdentifier);
    }

    private @NonNull DataTreeEffectiveStatement<?> pushData(EffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        if (parent instanceof DataTreeAwareEffectiveStatement) {
            DataTreeAwareEffectiveStatement dataTreeParent = (DataTreeAwareEffectiveStatement)parent;
            return this.pushData(dataTreeParent, nodeIdentifier);
        }
        throw new IllegalStateException("Cannot descend data tree at " + parent);
    }

    private @NonNull DataTreeEffectiveStatement<?> pushData(@NonNull DataTreeAwareEffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        DataTreeEffectiveStatement ret = (DataTreeEffectiveStatement)parent.findDataTreeNode(nodeIdentifier).orElseThrow(() -> SchemaInferenceStack.notPresent(parent, "Data tree child", nodeIdentifier));
        this.deque.addLast((EffectiveStatement<?, ?>)ret);
        this.clean = false;
        return ret;
    }

    private @NonNull DataTreeEffectiveStatement<?> pushFirstData(@NonNull QName nodeIdentifier) {
        ModuleEffectiveStatement module = this.getModule(nodeIdentifier);
        DataTreeEffectiveStatement<?> ret = this.pushData((DataTreeAwareEffectiveStatement<?, ?>)module, nodeIdentifier);
        this.currentModule = module;
        return ret;
    }

    private @NonNull TypedefEffectiveStatement pushTypedef(@NonNull QName nodeIdentifier) {
        EffectiveStatement<?, ?> parent = this.deque.peekLast();
        return parent != null ? this.pushTypedef(parent, nodeIdentifier) : this.pushFirstTypedef(nodeIdentifier);
    }

    private @NonNull TypedefEffectiveStatement pushTypedef(@NonNull EffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        if (parent instanceof TypedefAwareEffectiveStatement) {
            TypedefAwareEffectiveStatement aware = (TypedefAwareEffectiveStatement)parent;
            TypedefEffectiveStatement ret = (TypedefEffectiveStatement)aware.findTypedef(nodeIdentifier).orElseThrow(() -> SchemaInferenceStack.notPresent(parent, "Typedef", nodeIdentifier));
            this.deque.addLast((EffectiveStatement<?, ?>)ret);
            return ret;
        }
        throw SchemaInferenceStack.notPresent(parent, "Typedef", nodeIdentifier);
    }

    private @NonNull TypedefEffectiveStatement pushFirstTypedef(@NonNull QName nodeIdentifier) {
        ModuleEffectiveStatement module = this.getModule(nodeIdentifier);
        TypedefEffectiveStatement ret = this.pushTypedef((EffectiveStatement<?, ?>)module, nodeIdentifier);
        this.currentModule = module;
        return ret;
    }

    private @NonNull ModuleEffectiveStatement getModule(@NonNull QName nodeIdentifier) {
        ModuleEffectiveStatement module = (ModuleEffectiveStatement)this.modelContext.getModuleStatements().get(nodeIdentifier.getModule());
        if (module == null) {
            throw new IllegalArgumentException("Module for " + nodeIdentifier + " not found");
        }
        return module;
    }

    private Collection<QName> simplePathFromRoot() {
        return this.clean ? this.qnames() : this.reconstructQNames();
    }

    private Collection<QName> qnames() {
        return Collections2.transform(this.deque, stmt -> {
            Object patt40158$temp = stmt.argument();
            if (patt40158$temp instanceof QName) {
                QName qname = (QName)patt40158$temp;
                return qname;
            }
            throw new VerifyException("Unexpected statement " + stmt);
        });
    }

    private Collection<QName> reconstructQNames() {
        return this.reconstructSchemaInferenceStack().qnames();
    }

    private SchemaInferenceStack reconstructSchemaInferenceStack() {
        SchemaInferenceStack tmp = new SchemaInferenceStack(this.modelContext, this.deque.size());
        for (EffectiveStatement<?, ?> stmt : this.deque) {
            if (stmt instanceof DataTreeEffectiveStatement) {
                DataTreeEffectiveStatement dataTree = (DataTreeEffectiveStatement)stmt;
                tmp.resolveDataTreeSteps((QName)dataTree.argument());
                continue;
            }
            if (stmt instanceof ChoiceEffectiveStatement) {
                ChoiceEffectiveStatement choice = (ChoiceEffectiveStatement)stmt;
                tmp.resolveChoiceSteps((QName)choice.argument());
                continue;
            }
            if (stmt instanceof SchemaTreeEffectiveStatement) {
                SchemaTreeEffectiveStatement schemaTree = (SchemaTreeEffectiveStatement)stmt;
                tmp.enterSchemaTree((QName)schemaTree.argument());
                continue;
            }
            if (stmt instanceof GroupingEffectiveStatement) {
                GroupingEffectiveStatement grouping = (GroupingEffectiveStatement)stmt;
                tmp.enterGrouping((QName)grouping.argument());
                continue;
            }
            if (stmt instanceof TypedefEffectiveStatement) {
                TypedefEffectiveStatement typedef = (TypedefEffectiveStatement)stmt;
                tmp.enterTypedef((QName)typedef.argument());
                continue;
            }
            throw new VerifyException("Unexpected statement " + stmt);
        }
        if (this.deque.size() == tmp.deque.size()) {
            this.clean = true;
            return this;
        }
        return tmp;
    }

    private void resolveChoiceSteps(@NonNull QName nodeIdentifier) {
        EffectiveStatement<?, ?> parent = this.deque.peekLast();
        if (parent instanceof ChoiceEffectiveStatement) {
            ChoiceEffectiveStatement choice = (ChoiceEffectiveStatement)parent;
            this.resolveChoiceSteps(choice, nodeIdentifier);
        } else {
            this.enterSchemaTree(nodeIdentifier);
        }
    }

    private void resolveChoiceSteps(@NonNull ChoiceEffectiveStatement parent, @NonNull QName nodeIdentifier) {
        for (EffectiveStatement stmt : parent.effectiveSubstatements()) {
            CaseEffectiveStatement caze;
            Object var7_6;
            if (!(stmt instanceof CaseEffectiveStatement) || !((var7_6 = (caze = (CaseEffectiveStatement)stmt).findSchemaTreeNode(nodeIdentifier).orElse(null)) instanceof ChoiceEffectiveStatement)) continue;
            ChoiceEffectiveStatement found = var7_6;
            this.deque.addLast((EffectiveStatement<?, ?>)caze);
            this.deque.addLast((EffectiveStatement<?, ?>)found);
            return;
        }
        throw new VerifyException("Failed to resolve " + nodeIdentifier + " in " + parent);
    }

    private void resolveDataTreeSteps(@NonNull QName nodeIdentifier) {
        EffectiveStatement<?, ?> parent = this.deque.peekLast();
        if (parent == null) {
            ModuleEffectiveStatement module = this.getModule(nodeIdentifier);
            this.resolveDataTreeSteps((SchemaTreeAwareEffectiveStatement<?, ?>)module, nodeIdentifier);
            this.currentModule = module;
        } else if (parent instanceof SchemaTreeAwareEffectiveStatement) {
            SchemaTreeAwareEffectiveStatement schemaTreeParent = (SchemaTreeAwareEffectiveStatement)parent;
            this.resolveDataTreeSteps(schemaTreeParent, nodeIdentifier);
        } else {
            throw new VerifyException("Unexpected parent " + parent);
        }
    }

    private void resolveDataTreeSteps(@NonNull SchemaTreeAwareEffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        SchemaTreeEffectiveStatement found = parent.findSchemaTreeNode(nodeIdentifier).orElse(null);
        if (found instanceof DataTreeEffectiveStatement) {
            this.deque.addLast((EffectiveStatement<?, ?>)found);
            return;
        }
        ArrayDeque match = new ArrayDeque();
        for (EffectiveStatement stmt : parent.effectiveSubstatements()) {
            ChoiceEffectiveStatement choice;
            if (!(stmt instanceof ChoiceEffectiveStatement) || !SchemaInferenceStack.searchChoice(match, choice = (ChoiceEffectiveStatement)stmt, nodeIdentifier)) continue;
            this.deque.addAll(match);
            return;
        }
        throw new VerifyException("Failed to resolve " + nodeIdentifier + " in " + parent);
    }

    private static boolean searchCase(@NonNull ArrayDeque<EffectiveStatement<QName, ?>> result, @NonNull CaseEffectiveStatement parent, @NonNull QName nodeIdentifier) {
        result.addLast((EffectiveStatement<QName, ?>)parent);
        for (EffectiveStatement stmt : parent.effectiveSubstatements()) {
            ChoiceEffectiveStatement choice;
            if (stmt instanceof DataTreeEffectiveStatement) {
                DataTreeEffectiveStatement dataTree = (DataTreeEffectiveStatement)stmt;
                if (nodeIdentifier.equals(stmt.argument())) {
                    result.addLast((EffectiveStatement<QName, ?>)dataTree);
                    return true;
                }
            }
            if (!(stmt instanceof ChoiceEffectiveStatement) || !SchemaInferenceStack.searchChoice(result, choice = (ChoiceEffectiveStatement)stmt, nodeIdentifier)) continue;
            return true;
        }
        result.removeLast();
        return false;
    }

    private static boolean searchChoice(@NonNull ArrayDeque<EffectiveStatement<QName, ?>> result, @NonNull ChoiceEffectiveStatement parent, @NonNull QName nodeIdentifier) {
        result.addLast((EffectiveStatement<QName, ?>)parent);
        for (EffectiveStatement stmt : parent.effectiveSubstatements()) {
            CaseEffectiveStatement caze;
            if (!(stmt instanceof CaseEffectiveStatement) || !SchemaInferenceStack.searchCase(result, caze = (CaseEffectiveStatement)stmt, nodeIdentifier)) continue;
            return true;
        }
        result.removeLast();
        return false;
    }

    private static <T> @NonNull T checkNonNullState(@Nullable T obj) {
        if (obj == null) {
            throw new IllegalStateException("Cannot execute on empty stack");
        }
        return obj;
    }

    private static @NonNull IllegalArgumentException notPresent(@NonNull EffectiveStatement<?, ?> parent, @NonNull String name, QName nodeIdentifier) {
        return new IllegalArgumentException(name + " " + nodeIdentifier + " not present in " + SchemaInferenceStack.describeParent(parent));
    }

    private static @NonNull String describeParent(@NonNull EffectiveStatement<?, ?> parent) {
        QName qname;
        if (parent instanceof SchemaTreeEffectiveStatement) {
            return "schema parent " + parent.argument();
        }
        if (parent instanceof GroupingEffectiveStatement) {
            return "grouping " + parent.argument();
        }
        if (parent instanceof ModuleEffectiveStatement) {
            ModuleEffectiveStatement module = (ModuleEffectiveStatement)parent;
            return "module " + ((UnresolvedQName.Unqualified)module.argument()).bindTo(module.localQNameModule());
        }
        Object arg = parent.argument();
        return "parent " + (arg instanceof QName ? (qname = (QName)arg) : parent);
    }

    static {
        if (VERIFY_DEFAULT_SCHEMA_TREE_INFERENCE) {
            LoggerFactory.getLogger(SchemaInferenceStack.class).info("SchemaTreeStack.ofInference(DefaultSchemaTreeInference) argument is being verified");
        }
    }

    @Beta
    public static final class Inference
    extends AbstractEffectiveStatementInference<EffectiveStatement<?, ?>> {
        private final ArrayDeque<EffectiveStatement<?, ?>> deque;
        private final ModuleEffectiveStatement currentModule;
        private final int groupingDepth;
        private final boolean clean;

        Inference(@NonNull EffectiveModelContext modelContext, ArrayDeque<EffectiveStatement<?, ?>> deque, ModuleEffectiveStatement currentModule, int groupingDepth, boolean clean) {
            super(modelContext);
            this.deque = Objects.requireNonNull(deque);
            this.currentModule = currentModule;
            this.groupingDepth = groupingDepth;
            this.clean = clean;
        }

        public static @NonNull Inference of(EffectiveModelContext modelContext) {
            return new Inference(modelContext, new ArrayDeque(), null, 0, true);
        }

        public static @NonNull Inference ofDataTreePath(EffectiveModelContext modelContext, QName ... qnames) {
            return qnames.length == 0 ? Inference.of(modelContext) : SchemaInferenceStack.ofDataTreePath(modelContext, qnames).toInference();
        }

        public List<EffectiveStatement<?, ?>> statementPath() {
            return ImmutableList.copyOf(this.deque);
        }

        public boolean isEmpty() {
            return this.deque.isEmpty();
        }

        public @NonNull SchemaInferenceStack toSchemaInferenceStack() {
            return new SchemaInferenceStack(this.modelContext(), this.deque, this.currentModule, this.groupingDepth, this.clean);
        }
    }
}

