/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.transform;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.etsi.mts.tdl.Annotation;
import org.etsi.mts.tdl.AnnotationType;
import org.etsi.mts.tdl.Constraint;
import org.etsi.mts.tdl.ConstraintType;
import org.etsi.mts.tdl.DataElementMapping;
import org.etsi.mts.tdl.DataResourceMapping;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.ElementImport;
import org.etsi.mts.tdl.EnumDataType;
import org.etsi.mts.tdl.MappableDataElement;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.PackageableElement;
import org.etsi.mts.tdl.Parameter;
import org.etsi.mts.tdl.ParameterMapping;
import org.etsi.mts.tdl.SimpleDataType;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.tdlFactory;
import org.etsi.mts.tdl.tdlPackage;

public abstract class AbstractTranslator {
    protected DataResourceMapping drm;
    protected DataResourceMapping drmTarget;
    private Package generatedPackage;
    protected SimpleDataType stringType;
    private Resource targetResource;
    protected SimpleDataType referencedType;
    protected boolean useQualifiers = true;
    protected boolean fullPrefix = false;
    protected String sourceMappingTag = "SOURCE_MAPPING";
    protected String targetMappingTag = "TARGET_MAPPING";

    public abstract void translate(String var1) throws Exception;

    public void initTargetResource(String name) {
        this.generatedPackage = tdlFactory.eINSTANCE.createPackage();
        this.generatedPackage.setName("generated_from_" + name);
        this.targetResource.getContents().add((Object)this.generatedPackage);
        this.stringType = this.getSimpleDataTypeFor("String");
        this.referencedType = this.getSimpleDataTypeFor("TODO_RESOLVE_REFERENCED");
    }

    public void addImports(Package p) {
        this.generatedPackage.getImport().addAll((Collection)p.getImport());
        ElementImport sourceImport = tdlFactory.eINSTANCE.createElementImport();
        sourceImport.setImportedPackage(p);
        this.generatedPackage.getImport().add((Object)sourceImport);
    }

    protected DataType getDataTypeFor(String name) {
        return (DataType)this.getTypeFor(AbstractTranslator.cleanName(name), tdlPackage.Literals.DATA_TYPE);
    }

    protected SimpleDataType getSimpleDataTypeFor(String name) {
        return (SimpleDataType)this.getTypeFor(AbstractTranslator.cleanName(name), tdlPackage.Literals.SIMPLE_DATA_TYPE);
    }

    protected EnumDataType getEnumDataTypeFor(String name) {
        return (EnumDataType)this.getTypeFor(AbstractTranslator.cleanName(name), tdlPackage.Literals.ENUM_DATA_TYPE);
    }

    protected StructuredDataType getStructuredDataTypeFor(String name) {
        return (StructuredDataType)this.getTypeFor(AbstractTranslator.cleanName(name), tdlPackage.Literals.STRUCTURED_DATA_TYPE);
    }

    public static String cleanName(String name) {
        List<String> keywords = List.of("Message", "Time", "Type", "instance", "size", "component");
        if (keywords.contains(name)) {
            name = "^" + name;
        }
        name = name.replaceAll("-", "_").replaceAll(" ", "_").replaceAll(":", "_").replaceAll("\\.", "_");
        return name;
    }

    protected <T extends PackageableElement> T getTypeFor(String name, EClass targetType) {
        String cleanName = AbstractTranslator.cleanName(name);
        TreeMap<String, String> mappings = new TreeMap<String, String>();
        mappings.put("AsnInteger", "Integer");
        mappings.put("AsnBoolean", "Boolean");
        mappings.put("AsnOctetString", "OCTETSTRING");
        mappings.put("AsnBitString", "BITSTRING");
        mappings.put("AsnReal", "Real");
        cleanName = mappings.getOrDefault(cleanName, cleanName);
        Object generatedType = this.findElementOfType(cleanName, targetType);
        if (generatedType == null) {
            generatedType = (PackageableElement)tdlFactory.eINSTANCE.create(targetType);
            generatedType.setName(cleanName);
            this.generatedPackage.getPackagedElement().add(generatedType);
        }
        return generatedType;
    }

    protected <T extends PackageableElement> T findElementOfType(String name, EClass targetType) {
        Optional<PackageableElement> optional = this.generatedPackage.getPackagedElement().stream().filter(e -> targetType.isInstance(e) && e.getName().equals(AbstractTranslator.cleanName(name))).findFirst();
        PackageableElement generatedType = null;
        if (optional.isPresent()) {
            generatedType = optional.get();
        }
        return (T)generatedType;
    }

    protected <T extends NamedElement> T findContentWithName(String name, NamedElement container, EClass targetType) {
        Optional<NamedElement> optional = container.eContents().stream().filter(e -> targetType.isInstance(e)).map(e -> (NamedElement)e).filter(e -> e.getName().equals(name)).findFirst();
        NamedElement content = null;
        if (optional.isPresent()) {
            content = optional.get();
        }
        return (T)content;
    }

    protected <T extends NamedElement> T getContentWithName(String name, NamedElement container, EClass targetType) {
        String cleanName = AbstractTranslator.cleanName(name);
        Object content = this.findContentWithName(cleanName, container, targetType);
        if (content == null) {
            content = (NamedElement)tdlFactory.eINSTANCE.create(targetType);
            content.setName(cleanName);
        }
        return content;
    }

    protected <T extends Element> Optional<T> getContentWithName(String name, NamedElement container, Class<T> type) {
        Optional<Element> optional = container.eContents().stream().filter(e -> type.isInstance(e)).map(e -> (Element)e).filter(e -> e.getName().equals(name)).findFirst();
        return optional;
    }

    protected <T extends Element> Optional<T> getContentWithPredicate(Predicate<? super T> predicate, NamedElement container, Class<T> type) {
        Optional<? super T> optional = container.eContents().stream().filter(e -> type.isInstance(e)).map(e -> (Element)e).filter(predicate).findFirst();
        return optional;
    }

    protected void annotateWith(DataType generatedType, String annotationName) {
        AnnotationType annotationType = (AnnotationType)this.getTypeFor(AbstractTranslator.cleanName(annotationName), tdlPackage.Literals.ANNOTATION_TYPE);
        if (!generatedType.getAnnotation().stream().anyMatch(a -> a.getKey() == annotationType)) {
            Annotation annotation = tdlFactory.eINSTANCE.createAnnotation();
            annotation.setKey(annotationType);
            generatedType.getAnnotation().add((Object)annotation);
        }
    }

    protected void constrainWith(DataType generatedType, String constraintName) {
        ConstraintType constraintType = (ConstraintType)this.getTypeFor(AbstractTranslator.cleanName(constraintName), tdlPackage.Literals.CONSTRAINT_TYPE);
        if (!generatedType.getConstraint().stream().anyMatch(a -> a.getType() == constraintType)) {
            Constraint constraint = tdlFactory.eINSTANCE.createConstraint();
            constraint.setType(constraintType);
            generatedType.getConstraint().add((Object)constraint);
        }
    }

    protected DataElementMapping addDataElementMapping(String uri, DataType dataType, String tag) {
        DataElementMapping mapping = (DataElementMapping)this.getTypeFor(String.valueOf(dataType.getName()) + "_" + tag, tdlPackage.Literals.DATA_ELEMENT_MAPPING);
        mapping.setMappableDataElement((MappableDataElement)dataType);
        mapping.setElementURI(uri);
        mapping.setDataResourceMapping(this.drm);
        return mapping;
    }

    protected void addParameterMapping(DataElementMapping mapping, Parameter p, String uri) {
        Optional<ParameterMapping> opm = this.getContentWithPredicate(e -> e.getParameter() == p, (NamedElement)mapping, ParameterMapping.class);
        if (opm.isEmpty()) {
            ParameterMapping pm = (ParameterMapping)tdlFactory.eINSTANCE.create(tdlPackage.Literals.PARAMETER_MAPPING);
            pm.setParameter(p);
            pm.setParameterURI(uri.replaceAll("\\^", ""));
            mapping.getParameterMapping().add((Object)pm);
        }
    }

    public Resource getTargetResource() {
        return this.targetResource;
    }

    public void setTargetResource(Resource targetResource) {
        this.targetResource = targetResource;
    }

    public Package getGeneratedPackage() {
        return this.generatedPackage;
    }

    public void setGeneratedPackage(Package generatedPackage) {
        this.generatedPackage = generatedPackage;
    }
}

