/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.resources;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ResourceHandler {
    public static URI getSourceUri(Class c, String bundleName, String source) throws URISyntaxException {
        URI uri = new File(source).toURI();
        if (Platform.isRunning()) {
            Bundle bundle = Platform.getBundle((String)bundleName);
            URL url = bundle.getEntry(source);
            uri = url.toURI();
        } else {
            uri = ResourceHandler.getResourceFile(c, source);
        }
        return uri;
    }

    public static URI getResourceFile(Class c, String relativePath) {
        URI uri = null;
        URL location = c.getProtectionDomain().getCodeSource().getLocation();
        String codeLocation = location.toString();
        try {
            if (codeLocation.endsWith(".jar")) {
                try {
                    Enumeration<URL> resources = ClassLoader.getSystemResources(relativePath.replaceAll("epsilon/", ""));
                    URL nextElement = resources.nextElement();
                    uri = nextElement.toURI();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                URL resource = c.getClassLoader().getResource(relativePath.replaceAll("(epsilon|resource)/", ""));
                uri = resource.toURI();
            }
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        return uri;
    }
}

