/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.wizards.importWizards;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.xtext.util.StringInputStream;
import org.etsi.mts.tdl.json2tdl.JSONConverter;
import org.etsi.mts.tdl.openapi2tdl.next.ConverterNext;
import org.osgi.service.prefs.Preferences;

public class ImportWizardPage
extends WizardNewFileCreationPage {
    protected FileFieldEditor editor;
    private boolean inline = false;
    private boolean copySource = false;
    private IPath sourcePath;
    LinkedHashMap<String, String> dataFormats = new LinkedHashMap();

    public ImportWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setTitle(pageName);
        this.setDescription("Import data definitions from a file from the local file system into the workspace");
        this.loadDataFormat("org.etsi.mts.tdl.openapi2tdl.next", "OpenAPI", "*.yaml");
        this.loadDataFormat("org.etsi.mts.tdl.asn2tdl", "ASN.1", "*.asn1;*.asn");
        this.loadDataFormat("org.etsi.mts.tdl.json2tdl", "JSON", "*.json");
        this.loadDataFormat("org.etsi.mts.tdl.yang2tdl", "YANG", "*.yang");
    }

    protected void createAdvancedControls(Composite parent) {
        Composite fileSelectionArea = new Composite(parent, 0);
        GridData fileSelectionData = new GridData(768);
        fileSelectionArea.setLayoutData((Object)fileSelectionData);
        GridLayout fileSelectionLayout = new GridLayout();
        fileSelectionLayout.numColumns = 3;
        fileSelectionLayout.makeColumnsEqualWidth = false;
        fileSelectionLayout.marginWidth = 0;
        fileSelectionLayout.marginHeight = 0;
        fileSelectionArea.setLayout((Layout)fileSelectionLayout);
        String lastUsed = "LAST_USED";
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.etsi.mts.tdl.wizarads.import.data");
        this.editor = new FileFieldEditor("fileSelect", "Select Data File: ", fileSelectionArea);
        this.editor.getTextControl(fileSelectionArea).addModifyListener(arg_0 -> this.lambda$0((Preferences)preferences, lastUsed, arg_0));
        this.editor.getTextControl(fileSelectionArea).setText(preferences.get(lastUsed, ""));
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(String.join((CharSequence)";", this.dataFormats.values()));
        extensions.addAll(this.dataFormats.values());
        this.editor.setFileExtensions((String[])extensions.toArray(String[]::new));
        fileSelectionArea.moveAbove(null);
        Label labelCopy = new Label(fileSelectionArea, 0);
        labelCopy.setText("Copy Data File:");
        Button buttonCopy = new Button(fileSelectionArea, 32);
        buttonCopy.setSelection(false);
        buttonCopy.addSelectionListener(SelectionListener.widgetSelectedAdapter(this::copyDataDefinitions));
        new Label(fileSelectionArea, 0);
        Label labelFlatten = new Label(fileSelectionArea, 0);
        labelFlatten.setText("Import Inline Definitions:");
        Button buttonFlatten = new Button(fileSelectionArea, 32);
        buttonFlatten.setSelection(false);
        buttonFlatten.addSelectionListener(SelectionListener.widgetSelectedAdapter(this::flattenDataDefinitions));
        new Label(fileSelectionArea, 0);
    }

    private void loadDataFormat(String bundleName, String label, String extension) {
        if (Platform.getBundle((String)bundleName) != null) {
            this.dataFormats.put(label, extension);
        }
    }

    protected void createLinkTarget() {
    }

    protected InputStream getInitialContents() {
        try {
            if (this.editor.getStringValue().endsWith(".yaml")) {
                System.out.println("From OpenAPI YAML...");
                String content = ConverterNext.processToString((String)this.editor.getStringValue(), (String)(String.valueOf(this.editor.getStringValue()) + ".tdltx"), (String)"SOURCE_MAPPING", (String)"TARGET_MAPPING", (boolean)this.inline);
                return new StringInputStream(content);
            }
            if (this.editor.getStringValue().endsWith(".json")) {
                System.out.println("From JSON...");
                String content = JSONConverter.processToString((String)this.editor.getStringValue(), (String)(String.valueOf(this.editor.getStringValue()) + "-generated.tdltx"));
                return new StringInputStream(content);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getNewFileLabel() {
        return "Imported Package Name:";
    }

    protected IStatus validateLinkedResource() {
        return Status.OK_STATUS;
    }

    protected boolean validatePage() {
        boolean validatePage = super.validatePage();
        IPath sourcePath = Path.fromOSString((String)this.editor.getStringValue());
        boolean exists = sourcePath.toFile().exists();
        if (!exists) {
            this.setErrorMessage("The selected data file path is not valid.");
        }
        return exists && validatePage;
    }

    private void flattenDataDefinitions(SelectionEvent e) {
        this.inline = ((Button)e.getSource()).getSelection();
    }

    private void copyDataDefinitions(SelectionEvent e) {
        this.setCopySource(((Button)e.getSource()).getSelection());
    }

    public boolean isCopySource() {
        return this.copySource;
    }

    public void setCopySource(boolean copySource) {
        this.copySource = copySource;
    }

    public IPath getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(IPath sourcePath) {
        this.sourcePath = sourcePath;
    }

    private /* synthetic */ void lambda$0(Preferences preferences, String string, ModifyEvent e) {
        this.setSourcePath((IPath)new Path(this.editor.getStringValue()));
        if (!this.getSourcePath().lastSegment().equals("null")) {
            preferences.put(string, this.getSourcePath().toOSString());
            this.setFileName(String.valueOf(this.getSourcePath().lastSegment()) + ".tdltx");
        }
    }
}

