/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.tools.to.docx.poi.ui.handlers;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.etsi.mts.tdl.tools.to.docx.poi.Generator;

public class GenerationHandler
extends AbstractHandler {
    @Inject
    IResourceSetProvider resourceSetProvider;
    private IWorkbenchWindow window;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Object firstElement;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEditorInput input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        IFile file = null;
        if (input != null && input instanceof FileEditorInput) {
            file = ((FileEditorInput)input).getFile();
        } else if (selection != null && selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            file = (IFile)firstElement;
        }
        if (file != null) {
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource r = rs.getResource(uri, true);
            EcoreUtil.resolveAll((Resource)r);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new LabelProvider());
            dialog.setTitle("Generation Configuration");
            dialog.setMessage("Select template:");
            dialog.setElements((Object[])new String[]{"TO_4_TABLE_TEMPLATE_EDITHELP", "TO_5_TABLE_TEMPLATE_ONEM2M", "TO_2_TABLE_TEMPLATE"});
            dialog.setInitialElementSelections(Arrays.asList(Generator.selectedTemplate));
            if (dialog.open() != 0) {
                return false;
            }
            Object[] result = dialog.getResult();
            String selected = (String)result[0];
            Generator generator = new Generator();
            String target = String.valueOf(file.getLocation().toOSString()) + ".docx";
            try {
                generator.generate(r, target, file.getName(), selected);
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Generation Results", (String)("Generated output in " + target));
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Generation Results", (String)"Generation failed!");
            }
        }
        return null;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public boolean isEnabled() {
        return true;
    }
}

