/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.graphical.project;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.session.UserSession;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.SimpleDataInstance;
import org.etsi.mts.tdl.SimpleDataType;
import org.etsi.mts.tdl.tdlFactory;

public class ProjectWizard
extends BasicNewProjectResourceWizard
implements INewWizard {
    private IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
    }

    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        IProject project = this.getNewProject();
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            String[] verdictNames;
            this.addNature(project, "org.eclipse.xtext.ui.shared.xtextNature");
            ModelingProjectManager.INSTANCE.convertToModelingProject(project, (IProgressMonitor)monitor);
            IFile file = project.getFile("model.tdl");
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource r = rs.createResource(uri);
            Package pck = tdlFactory.eINSTANCE.createPackage();
            pck.setName("Model");
            r.getContents().add((Object)pck);
            String[] typeNames = new String[]{"String", "Boolean", "Integer", "Verdict"};
            SimpleDataType verdictType = null;
            String[] stringArray = typeNames;
            int n = typeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String typeName = stringArray[n2];
                SimpleDataType type = tdlFactory.eINSTANCE.createSimpleDataType();
                type.setName(typeName);
                pck.getPackagedElement().add((Object)type);
                if (typeName.equals("Verdict")) {
                    verdictType = type;
                }
                ++n2;
            }
            String[] stringArray2 = verdictNames = new String[]{"pass", "fail", "inconclusive"};
            int n3 = verdictNames.length;
            n = 0;
            while (n < n3) {
                String verdictName = stringArray2[n];
                SimpleDataInstance verdict = tdlFactory.eINSTANCE.createSimpleDataInstance();
                verdict.setName(verdictName);
                verdict.setDataType((DataType)verdictType);
                pck.getPackagedElement().add((Object)verdict);
                ++n;
            }
            r.save(null);
            URI sessionUri = URI.createPlatformResourceURI((String)project.getFile("representations.aird").getFullPath().toString(), (boolean)true);
            Session session = SessionManager.INSTANCE.getSession(sessionUri, (IProgressMonitor)monitor);
            UserSession uSession = new UserSession(session);
            uSession.selectViewpoint("org.etsi.mts.tdl");
            uSession.save((IProgressMonitor)monitor);
            session.save((IProgressMonitor)monitor);
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void addNature(IProject project, String ... natureIds) throws CoreException {
        IProjectDescription desc = project.getDescription();
        String[] ids = desc.getNatureIds();
        String[] newIds = Arrays.copyOf(ids, ids.length + natureIds.length);
        System.arraycopy(natureIds, 0, newIds, ids.length, natureIds.length);
        desc.setNatureIds(newIds);
        project.setDescription(desc, null);
    }
}

