/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.graphical.extensions;

import com.google.inject.Injector;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.serializer.impl.Serializer;
import org.etsi.mts.tdl.ActionReference;
import org.etsi.mts.tdl.ComponentInstanceBinding;
import org.etsi.mts.tdl.DataInstanceUse;
import org.etsi.mts.tdl.DataUse;
import org.etsi.mts.tdl.ParameterBinding;
import org.etsi.mts.tdl.TestDescriptionReference;
import org.etsi.mts.tdl.graphical.labels.DataStandaloneSetup;

public class DataUseLabelProvider {
    public String separator(EObject o, List<String> c, String s) {
        String output = "";
        for (String e : c) {
            output = String.valueOf(output) + s + e;
        }
        if (c.size() > 0) {
            return output.substring(s.length());
        }
        return output;
    }

    public String serialise(EObject o, ActionReference u, String separator) {
        Injector injector = new DataStandaloneSetup().createInjectorAndDoEMFRegistration();
        String s = "";
        Serializer serializer = (Serializer)injector.getInstance(Serializer.class);
        try {
            for (ParameterBinding b : u.getArgument()) {
                s = String.valueOf(s) + separator + this.serialise((EObject)u, b);
            }
            if (s.length() > 0) {
                s = s.substring(separator.length());
                s = "(" + s + ")";
            }
        }
        catch (Exception ex) {
            System.out.println("Object could not be serialized");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        return s;
    }

    public String serialise(EObject o, TestDescriptionReference u, String type, String separator) {
        Injector injector = new DataStandaloneSetup().createInjectorAndDoEMFRegistration();
        String s = "";
        Serializer serializer = (Serializer)injector.getInstance(Serializer.class);
        try {
            if (u instanceof TestDescriptionReference) {
                if (type.equals("bindings")) {
                    for (ComponentInstanceBinding b : u.getComponentInstanceBinding()) {
                        s = String.valueOf(s) + separator + serializer.serialize((EObject)b);
                    }
                    if ((s = s.replaceAll("\\s+", " ").replaceAll("\t+", " ")).length() > 0) {
                        s = s.substring(separator.length());
                    }
                } else if (type.equals("parameters")) {
                    for (ParameterBinding b : u.getArgument()) {
                        s = String.valueOf(s) + separator + this.serialise((EObject)u, b);
                    }
                    if (s.length() > 0) {
                        s = s.substring(separator.length());
                        s = "(" + s + ")";
                    }
                } else {
                    s = String.valueOf(s) + "Unsupported type argument";
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Object could not be serialized");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        return s;
    }

    public String serialise(EObject o, ParameterBinding p) {
        Injector injector = new DataStandaloneSetup().createInjectorAndDoEMFRegistration();
        String s = "";
        ISerializer serializer = (ISerializer)injector.getInstance(ISerializer.class);
        XtextResource xr = null;
        try {
            try {
                if (!(p.eResource() instanceof XtextResource)) {
                    URI uri = p.eResource().getURI();
                    p = (ParameterBinding)EcoreUtil.copy((EObject)p);
                    xr = this.createVirtualXtextResource(uri, (EObject)p);
                }
                SaveOptions options = SaveOptions.newBuilder().noValidation().getOptions();
                s = String.valueOf(s) + p.getParameter().getName();
                s = String.valueOf(s) + " = ";
                s = String.valueOf(s) + serializer.serialize((EObject)p.getDataUse(), options);
            }
            catch (Exception ex) {
                System.out.println("Object could not be serialized");
                System.err.println(ex);
                ex.printStackTrace();
                if (xr != null) {
                    xr.unload();
                }
            }
        }
        finally {
            if (xr != null) {
                xr.unload();
            }
        }
        return s;
    }

    public String serialise(EObject o, DataUse u) {
        Injector injector = new DataStandaloneSetup().createInjectorAndDoEMFRegistration();
        String s = "";
        ISerializer serializer = (ISerializer)injector.getInstance(ISerializer.class);
        XtextResource xr = null;
        try {
            try {
                if (!(u.eResource() instanceof XtextResource)) {
                    URI uri = u.eResource().getURI();
                    u = (DataUse)EcoreUtil.copy((EObject)u);
                    xr = this.createVirtualXtextResource(uri, (EObject)u);
                }
                SaveOptions options = SaveOptions.newBuilder().noValidation().getOptions();
                s = String.valueOf(s) + serializer.serialize((EObject)u, options);
            }
            catch (Exception ex) {
                System.out.println("Object could not be serialized");
                System.err.println(ex);
                ex.printStackTrace();
                if (xr != null) {
                    xr.unload();
                }
            }
        }
        finally {
            if (xr != null) {
                xr.unload();
            }
        }
        return s;
    }

    public String getDataUse(EObject o, DataUse u, String s) {
        String output = u.eClass().getName();
        if (u instanceof DataInstanceUse) {
            DataInstanceUse d = (DataInstanceUse)u;
            output = d.getDataInstance().getName();
            if (d.getArgument().size() > 0) {
                output = String.valueOf(output) + "(";
                for (ParameterBinding p : d.getArgument()) {
                    output = String.valueOf(output) + p.getParameter().getName() + " := ";
                    this.getDataUse((EObject)d, p.getDataUse(), s);
                }
                output = String.valueOf(output) + ")";
            }
        } else {
            output = String.valueOf(output) + " (not yet implemented)";
        }
        return output;
    }

    private XtextResource createVirtualXtextResource(URI uri, EObject semanticElement) throws IOException {
        Injector xtextInjector = new DataStandaloneSetup().createInjectorAndDoEMFRegistration();
        IResourceFactory resourceFactory = (IResourceFactory)xtextInjector.getInstance(IResourceFactory.class);
        XtextResourceSet rs = (XtextResourceSet)xtextInjector.getInstance(XtextResourceSet.class);
        rs.setClasspathURIContext(this.getClass());
        XtextResource xtextVirtualResource = (XtextResource)resourceFactory.createResource(URI.createURI((String)uri.toString()));
        rs.getResources().add((Object)xtextVirtualResource);
        xtextVirtualResource.getContents().add((Object)semanticElement);
        return xtextVirtualResource;
    }
}

